/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrExpressionInterpreter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.LiteralEncoder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.NoOpSymbolResolver;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExtractCommonPredicatesExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.NormalizeOrExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ExpressionRewriteRuleSet;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.tsfile.read.common.type.Type;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    public static Expression rewrite(Expression expression, SessionInfo session, SymbolAllocator symbolAllocator, PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(plannerContext.getMetadata(), expression, expressionTypes);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(expression);
        expression = NormalizeOrExpressionRewriter.normalizeOrExpression(expression);
        expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        IrExpressionInterpreter interpreter = new IrExpressionInterpreter(expression, plannerContext, session, expressionTypes);
        Object optimized = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        return new LiteralEncoder(plannerContext).toExpression(optimized, expressionTypes.get(NodeRef.of(expression)));
    }

    public SimplifyExpressions(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        super(SimplifyExpressions.createRewrite(plannerContext, typeAnalyzer));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext, IrTypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSessionInfo(), context.getSymbolAllocator(), plannerContext, typeAnalyzer);
    }
}

