/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.udf.access.RecordIterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.MaskedRecordIterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.ObjectBigArray;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class GroupedUserDefinedAggregateAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedUserDefinedAggregateAccumulator.class);
    private final AggregateFunction aggregateFunction;
    private final ObjectBigArray<State> stateArray;
    private final List<Type> inputDataTypes;

    public GroupedUserDefinedAggregateAccumulator(AggregateFunction aggregateFunction, List<Type> inputDataTypes) {
        this.aggregateFunction = aggregateFunction;
        this.stateArray = new ObjectBigArray();
        this.inputDataTypes = inputDataTypes;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.stateArray.ensureCapacity(groupCount);
    }

    private State getOrCreateState(int groupId) {
        State state = this.stateArray.get(groupId);
        if (state == null) {
            state = this.aggregateFunction.createState();
            this.stateArray.set(groupId, state);
        }
        return state;
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments, AggregationMask mask) {
        RecordIterator iterator = mask.isSelectAll() ? new RecordIterator(Arrays.asList(arguments), this.inputDataTypes, arguments[0].getPositionCount()) : new MaskedRecordIterator(Arrays.asList(arguments), this.inputDataTypes, mask);
        int[] selectedPositions = mask.getSelectedPositions();
        int index = 0;
        while (iterator.hasNext()) {
            int groupId = groupIds[selectedPositions[index]];
            ++index;
            State state = this.getOrCreateState(groupId);
            this.aggregateFunction.addInput(state, iterator.next());
        }
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of UDAF should be BinaryColumn");
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            State otherState = this.aggregateFunction.createState();
            Binary otherStateBinary = argument.getBinary(i);
            otherState.deserialize(otherStateBinary.getValues());
            this.aggregateFunction.combineState(this.getOrCreateState(groupIds[i]), otherState);
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of UDAF should be BinaryColumn");
        if (this.stateArray.get(groupId) == null) {
            throw new IllegalStateException(String.format("State for group %d is not found", groupId));
        }
        byte[] bytes = this.stateArray.get(groupId).serialize();
        columnBuilder.writeBinary(new Binary(bytes));
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        ResultValue resultValue = new ResultValue(columnBuilder);
        this.aggregateFunction.outputFinal(this.getOrCreateState(groupId), resultValue);
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.stateArray.reset();
    }

    @Override
    public void close() {
        this.aggregateFunction.beforeDestroy();
        this.stateArray.forEach(State::destroyState);
    }
}

