/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CountAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(CountAccumulator.class);
    private long countState = 0L;

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new CountAccumulator();
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Count should be one column");
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            if (!arguments[0].mayHaveNull()) {
                this.countState += (long)positionCount;
            } else {
                for (int i = 0; i < positionCount; ++i) {
                    if (arguments[0].isNull(i)) continue;
                    ++this.countState;
                }
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                if (arguments[0].isNull(selectedPositions[i])) continue;
                ++this.countState;
            }
        }
    }

    @Override
    public void removeInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Count should be one column");
        int count = arguments[0].getPositionCount();
        if (!arguments[0].mayHaveNull()) {
            this.countState -= (long)count;
        } else {
            for (int i = 0; i < count; ++i) {
                if (arguments[0].isNull(i)) continue;
                --this.countState;
            }
        }
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            this.countState += argument.getLong(i);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countState);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        this.countState += (long)statistics[0].getCount();
    }

    @Override
    public void reset() {
        this.countState = 0L;
    }

    @Override
    public boolean removable() {
        return true;
    }
}

