/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AbstractWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MemPointIteratorFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableMemChunk
extends AbstractWritableMemChunk {
    private IMeasurementSchema schema;
    private TVList list;
    private List<TVList> sortedList;
    private long sortedRowCount = 0L;
    private static final String UNSUPPORTED_TYPE = "Unsupported data type:";
    private static final Logger LOGGER = LoggerFactory.getLogger(WritableMemChunk.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final long TARGET_CHUNK_SIZE = CONFIG.getTargetChunkSize();
    private final long MAX_NUMBER_OF_POINTS_IN_CHUNK = CONFIG.getTargetChunkPointNum();
    private final int TVLIST_SORT_THRESHOLD = CONFIG.getTvListSortThreshold();

    public WritableMemChunk(IMeasurementSchema schema) {
        this.schema = schema;
        this.list = TVList.newList(schema.getType());
        this.sortedList = new ArrayList<TVList>();
    }

    private WritableMemChunk() {
    }

    protected void handoverTvList() {
        if (!this.list.isSorted()) {
            this.list.sort();
        }
        this.sortedList.add(this.list);
        this.sortedRowCount += (long)this.list.rowCount();
        this.list = TVList.newList(this.schema.getType());
    }

    @Override
    public void writeNonAlignedPoint(long insertTime, Object objectValue) {
        switch (this.schema.getType()) {
            case BOOLEAN: {
                this.putBoolean(insertTime, (Boolean)objectValue);
                break;
            }
            case INT32: 
            case DATE: {
                this.putInt(insertTime, (Integer)objectValue);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.putLong(insertTime, (Long)objectValue);
                break;
            }
            case FLOAT: {
                this.putFloat(insertTime, ((Float)objectValue).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(insertTime, (Double)objectValue);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.putBinary(insertTime, (Binary)objectValue);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType().name());
            }
        }
        if (this.TVLIST_SORT_THRESHOLD > 0 && this.list.rowCount() >= this.TVLIST_SORT_THRESHOLD) {
            this.handoverTvList();
        }
    }

    @Override
    public void writeAlignedPoints(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.list.getDataType());
    }

    @Override
    public void writeNonAlignedTablet(long[] times, Object valueList, BitMap bitMap, TSDataType dataType, int start, int end) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                this.putBooleans(times, boolValues, bitMap, start, end);
                break;
            }
            case INT32: 
            case DATE: {
                int[] intValues = (int[])valueList;
                this.putInts(times, intValues, bitMap, start, end);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                this.putLongs(times, longValues, bitMap, start, end);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                this.putFloats(times, floatValues, bitMap, start, end);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                this.putDoubles(times, doubleValues, bitMap, start, end);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                this.putBinaries(times, binaryValues, bitMap, start, end);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + dataType.name());
            }
        }
        if (this.TVLIST_SORT_THRESHOLD > 0 && this.list.rowCount() >= this.TVLIST_SORT_THRESHOLD) {
            this.handoverTvList();
        }
    }

    @Override
    public void writeAlignedTablet(long[] times, Object[] valueList, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.list.getDataType());
    }

    @Override
    public void putLong(long t, long v) {
        this.list.putLong(t, v);
    }

    @Override
    public void putInt(long t, int v) {
        this.list.putInt(t, v);
    }

    @Override
    public void putFloat(long t, float v) {
        this.list.putFloat(t, v);
    }

    @Override
    public void putDouble(long t, double v) {
        this.list.putDouble(t, v);
    }

    @Override
    public void putBinary(long t, Binary v) {
        this.list.putBinary(t, v);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        this.list.putBoolean(t, v);
    }

    @Override
    public void putAlignedRow(long t, Object[] v) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType());
    }

    @Override
    public void putLongs(long[] t, long[] v, BitMap bitMap, int start, int end) {
        this.list.putLongs(t, v, bitMap, start, end);
    }

    @Override
    public void putInts(long[] t, int[] v, BitMap bitMap, int start, int end) {
        this.list.putInts(t, v, bitMap, start, end);
    }

    @Override
    public void putFloats(long[] t, float[] v, BitMap bitMap, int start, int end) {
        this.list.putFloats(t, v, bitMap, start, end);
    }

    @Override
    public void putDoubles(long[] t, double[] v, BitMap bitMap, int start, int end) {
        this.list.putDoubles(t, v, bitMap, start, end);
    }

    @Override
    public void putBinaries(long[] t, Binary[] v, BitMap bitMap, int start, int end) {
        this.list.putBinaries(t, v, bitMap, start, end);
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, BitMap bitMap, int start, int end) {
        this.list.putBooleans(t, v, bitMap, start, end);
    }

    @Override
    public void putAlignedTablet(long[] t, Object[] v, BitMap[] bitMaps, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType());
    }

    @Override
    public synchronized void sortTvListForFlush() {
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public TVList getWorkingTVList() {
        return this.list;
    }

    @Override
    public void setWorkingTVList(TVList list) {
        this.list = list;
    }

    @Override
    public long count() {
        long count = this.list.count();
        for (TVList tvList : this.sortedList) {
            count += (long)tvList.count();
        }
        return count;
    }

    @Override
    public long rowCount() {
        return this.sortedRowCount + (long)this.list.rowCount();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public long getMaxTime() {
        long maxTime = this.list.getMaxTime();
        for (TVList tvList : this.sortedList) {
            maxTime = Math.max(maxTime, tvList.getMaxTime());
        }
        return maxTime;
    }

    @Override
    public long getMinTime() {
        long minTime = this.list.getMinTime();
        for (TVList tvList : this.sortedList) {
            minTime = Math.min(minTime, tvList.getMinTime());
        }
        return minTime;
    }

    @Override
    public long getFirstPoint() {
        if (this.count() == 0L) {
            return Long.MAX_VALUE;
        }
        return this.getMinTime();
    }

    @Override
    public long getLastPoint() {
        if (this.count() == 0L) {
            return Long.MIN_VALUE;
        }
        return this.getMaxTime();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0L;
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        int deletedNumber = this.list.delete(lowerBound, upperBound);
        for (TVList tvList : this.sortedList) {
            deletedNumber += tvList.delete(lowerBound, upperBound);
        }
        return deletedNumber;
    }

    public ChunkWriterImpl createIChunkWriter() {
        return new ChunkWriterImpl(this.schema);
    }

    public String toString() {
        TimeValuePair firstTvPair = null;
        TimeValuePair lastTvPair = null;
        int size = 0;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        ArrayList<TVList> tvLists = new ArrayList<TVList>(this.sortedList);
        tvLists.add(this.list);
        for (TVList tvList : tvLists) {
            for (int i = 0; i < tvList.rowCount(); ++i) {
                if (tvList.isNullValue(tvList.getValueIndex(i))) continue;
                ++size;
                long currentTime = tvList.getTime(i);
                if (currentTime < minTime) {
                    firstTvPair = tvList.getTimeValuePair(i);
                    minTime = currentTime;
                }
                if (currentTime < maxTime) continue;
                lastTvPair = tvList.getTimeValuePair(i);
                maxTime = currentTime;
            }
        }
        StringBuilder out = new StringBuilder("MemChunk Size: " + size + System.lineSeparator());
        if (size != 0) {
            out.append("Data type:").append(this.schema.getType()).append(System.lineSeparator());
            out.append("First point:").append(firstTvPair).append(System.lineSeparator());
            out.append("Last point:").append(lastTvPair).append(System.lineSeparator());
        }
        return out.toString();
    }

    public void encodeWorkingTVList(BlockingQueue<Object> ioTaskQueue) {
        TSDataType tsDataType = this.schema.getType();
        ChunkWriterImpl chunkWriterImpl = this.createIChunkWriter();
        long dataSizeInCurrentChunk = 0L;
        int pointNumInCurrentChunk = 0;
        for (int sortedRowIndex = 0; sortedRowIndex < this.list.rowCount(); ++sortedRowIndex) {
            if (this.list.isNullValue(this.list.getValueIndex(sortedRowIndex))) continue;
            long time = this.list.getTime(sortedRowIndex);
            if (sortedRowIndex + 1 < this.list.rowCount() && time == this.list.getTime(sortedRowIndex + 1)) continue;
            if (sortedRowIndex + 1 == this.list.rowCount()) {
                chunkWriterImpl.setLastPoint(true);
            }
            switch (tsDataType) {
                case BOOLEAN: {
                    chunkWriterImpl.write(time, this.list.getBoolean(sortedRowIndex));
                    dataSizeInCurrentChunk += 9L;
                    break;
                }
                case INT32: 
                case DATE: {
                    chunkWriterImpl.write(time, this.list.getInt(sortedRowIndex));
                    dataSizeInCurrentChunk += 12L;
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    chunkWriterImpl.write(time, this.list.getLong(sortedRowIndex));
                    dataSizeInCurrentChunk += 16L;
                    break;
                }
                case FLOAT: {
                    chunkWriterImpl.write(time, this.list.getFloat(sortedRowIndex));
                    dataSizeInCurrentChunk += 12L;
                    break;
                }
                case DOUBLE: {
                    chunkWriterImpl.write(time, this.list.getDouble(sortedRowIndex));
                    dataSizeInCurrentChunk += 16L;
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary value = this.list.getBinary(sortedRowIndex);
                    chunkWriterImpl.write(time, value);
                    dataSizeInCurrentChunk += 8L + MemUtils.getBinarySize(value);
                    break;
                }
                default: {
                    LOGGER.error("WritableMemChunk does not support data type: {}", (Object)tsDataType);
                }
            }
            if ((long)(++pointNumInCurrentChunk) <= this.MAX_NUMBER_OF_POINTS_IN_CHUNK && dataSizeInCurrentChunk <= this.TARGET_CHUNK_SIZE) continue;
            chunkWriterImpl.sealCurrentPage();
            chunkWriterImpl.clearPageWriter();
            try {
                ioTaskQueue.put(chunkWriterImpl);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            chunkWriterImpl = this.createIChunkWriter();
            dataSizeInCurrentChunk = 0L;
            pointNumInCurrentChunk = 0;
        }
        if (pointNumInCurrentChunk != 0) {
            chunkWriterImpl.sealCurrentPage();
            chunkWriterImpl.clearPageWriter();
            try {
                ioTaskQueue.put(chunkWriterImpl);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public synchronized void encode(BlockingQueue<Object> ioTaskQueue, BatchEncodeInfo encodeInfo, long[] times) {
        if (this.TVLIST_SORT_THRESHOLD == 0) {
            this.encodeWorkingTVList(ioTaskQueue);
            return;
        }
        ChunkWriterImpl chunkWriterImpl = this.createIChunkWriter();
        if (this.sortedList.isEmpty()) {
            encodeInfo.lastIterator = true;
        }
        ArrayList<TVList> tvLists = new ArrayList<TVList>(this.sortedList);
        tvLists.add(this.list);
        MemPointIterator timeValuePairIterator = MemPointIteratorFactory.create(this.schema.getType(), tvLists);
        while (timeValuePairIterator.hasNextBatch()) {
            timeValuePairIterator.encodeBatch((IChunkWriter)chunkWriterImpl, encodeInfo, times);
            if ((long)encodeInfo.pointNumInChunk < this.MAX_NUMBER_OF_POINTS_IN_CHUNK && encodeInfo.dataSizeInChunk < this.TARGET_CHUNK_SIZE) continue;
            chunkWriterImpl.sealCurrentPage();
            chunkWriterImpl.clearPageWriter();
            try {
                ioTaskQueue.put(chunkWriterImpl);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            chunkWriterImpl = this.createIChunkWriter();
            encodeInfo.resetPointAndSize();
        }
        if (encodeInfo.pointNumInChunk != 0) {
            chunkWriterImpl.sealCurrentPage();
            chunkWriterImpl.clearPageWriter();
            try {
                ioTaskQueue.put(chunkWriterImpl);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            encodeInfo.reset();
        }
    }

    @Override
    public void release() {
        this.maybeReleaseTvList(this.list);
        for (TVList tvList : this.sortedList) {
            this.maybeReleaseTvList(tvList);
        }
    }

    @Override
    public int serializedSize() {
        int serializedSize = this.schema.serializedSize() + this.list.serializedSize();
        serializedSize += 4;
        for (TVList tvList : this.sortedList) {
            serializedSize += tvList.serializedSize();
        }
        return serializedSize;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        byte[] bytes = new byte[this.schema.serializedSize()];
        this.schema.serializeTo(ByteBuffer.wrap(bytes));
        buffer.put(bytes);
        buffer.putInt(this.sortedList.size());
        for (TVList tvList : this.sortedList) {
            tvList.serializeToWAL(buffer);
        }
        this.list.serializeToWAL(buffer);
    }

    public static WritableMemChunk deserialize(DataInputStream stream) throws IOException {
        WritableMemChunk memChunk = new WritableMemChunk();
        memChunk.schema = MeasurementSchema.deserializeFrom((InputStream)stream);
        int sortedListSize = stream.readInt();
        memChunk.sortedList = new ArrayList<TVList>();
        for (int i = 0; i < sortedListSize; ++i) {
            TVList tvList = TVList.deserialize(stream);
            memChunk.sortedList.add(tvList);
        }
        memChunk.list = TVList.deserialize(stream);
        return memChunk;
    }

    public static WritableMemChunk deserializeSingleTVListMemChunks(DataInputStream stream) throws IOException {
        WritableMemChunk memChunk = new WritableMemChunk();
        memChunk.schema = MeasurementSchema.deserializeFrom((InputStream)stream);
        memChunk.list = TVList.deserialize(stream);
        return memChunk;
    }

    public List<TVList> getSortedList() {
        return this.sortedList;
    }

    private void filterDeletedTimestamp(TVList tvlist, List<TimeRange> deletionList, List<Long> timestampList) {
        long lastTime = Long.MIN_VALUE;
        int[] deletionCursor = new int[]{0};
        int rowCount = tvlist.rowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (tvlist.getBitMap() != null && tvlist.isNullValue(tvlist.getValueIndex(i))) continue;
            long curTime = tvlist.getTime(i);
            if (deletionList != null && ModificationUtils.isPointDeleted(curTime, deletionList, deletionCursor)) continue;
            if (i == rowCount - 1 || curTime != lastTime) {
                timestampList.add(curTime);
            }
            lastTime = curTime;
        }
    }

    public long[] getFilteredTimestamp(List<TimeRange> deletionList) {
        ArrayList<Long> timestampList = new ArrayList<Long>();
        this.filterDeletedTimestamp(this.list, deletionList, timestampList);
        for (TVList tvList : this.sortedList) {
            this.filterDeletedTimestamp(tvList, deletionList, timestampList);
        }
        List distinctTimestamps = timestampList.stream().distinct().collect(Collectors.toList());
        long[] filteredTimestamps = distinctTimestamps.stream().mapToLong(Long::longValue).toArray();
        Arrays.sort(filteredTimestamps);
        return filteredTimestamps;
    }
}

