/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PageIndexSortBuckets;

class SchemaPageContext {
    final long threadID = Thread.currentThread().getId();
    final PageIndexSortBuckets indexBuckets;
    final Map<Integer, ISchemaPage> referredPages = new HashMap<Integer, ISchemaPage>();
    final Set<Integer> lockTraces;
    final int[] treeTrace;
    int dirtyCnt = 0;
    int interleavedFlushCnt = 0;
    ISegmentedPage lastLeafPage = null;

    public SchemaPageContext() {
        this.indexBuckets = new PageIndexSortBuckets(SchemaFileConfig.SEG_SIZE_LST, this.referredPages);
        this.treeTrace = new int[16];
        this.lockTraces = new HashSet<Integer>();
    }

    public void markDirty(ISchemaPage page) {
        this.markDirty(page, false);
    }

    public void markDirty(ISchemaPage page, boolean forceReplace) {
        if (!page.isDirtyPage()) {
            ++this.dirtyCnt;
        }
        page.setDirtyFlag();
        this.refer(page);
        if (forceReplace && this.referredPages.containsKey(page.getPageIndex())) {
            if (this.referredPages.get(page.getPageIndex()).isDirtyPage()) {
                --this.dirtyCnt;
            }
            this.referredPages.put(page.getPageIndex(), page);
        }
    }

    public void traceLock(ISchemaPage page) {
        this.refer(page);
        this.lockTraces.add(page.getPageIndex());
    }

    public void refer(ISchemaPage page) {
        if (!this.referredPages.containsKey(page.getPageIndex())) {
            page.incrementAndGetRefCnt();
            this.referredPages.put(page.getPageIndex(), page);
        }
    }

    public void invokeLastLeaf(ISchemaPage page) {
        if (this.lastLeafPage == null) {
            this.lastLeafPage = page.getAsSegmentedPage();
        }
    }

    public void appendBucketIndex(PageIndexSortBuckets pisb) {
        for (int i = 0; i < SchemaFileConfig.SEG_SIZE_LST.length; ++i) {
            pisb.getBucket(i).addAll(this.indexBuckets.getBucket(i));
        }
    }
}

