/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlignedSeriesAggregationScanNode
extends SeriesAggregationSourceNode {
    private final AlignedPath alignedPath;
    private TRegionReplicaSet regionReplicaSet;

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList) {
        super(id, aggregationDescriptorList);
        this.alignedPath = alignedPath;
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
    }

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList, Ordering scanOrder, @Nullable GroupByTimeParameter groupByTimeParameter) {
        this(id, alignedPath, aggregationDescriptorList);
        this.scanOrder = scanOrder;
        this.groupByTimeParameter = groupByTimeParameter;
    }

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList, Ordering scanOrder, @Nullable Expression pushDownPredicate, @Nullable GroupByTimeParameter groupByTimeParameter, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, alignedPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
        this.pushDownPredicate = pushDownPredicate;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList, Ordering scanOrder, boolean outputEndTime, @Nullable Expression pushDownPredicate, @Nullable GroupByTimeParameter groupByTimeParameter, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, alignedPath, aggregationDescriptorList, scanOrder, pushDownPredicate, groupByTimeParameter, dataRegionReplicaSet);
        this.setOutputEndTime(outputEndTime);
    }

    public AlignedPath getAlignedPath() {
        return this.alignedPath;
    }

    @Override
    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for AlignedSeriesAggregationScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedSeriesAggregationScanNode(this.getPlanNodeId(), this.getAlignedPath(), this.getAggregationDescriptorList(), this.getScanOrder(), this.isOutputEndTime(), this.getPushDownPredicate(), this.getGroupByTimeParameter(), this.getRegionReplicaSet());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedSeriesAggregationScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_SERIES_AGGREGATE_SCAN.serialize(byteBuffer);
        this.alignedPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isOutputEndTime(), (ByteBuffer)byteBuffer);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            Expression.serialize(this.pushDownPredicate, byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_SERIES_AGGREGATE_SCAN.serialize(stream);
        this.alignedPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isOutputEndTime(), (OutputStream)stream);
        if (this.pushDownPredicate == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            Expression.serialize(this.pushDownPredicate, stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
    }

    public static AlignedSeriesAggregationScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath alignedPath = (AlignedPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        int aggregateDescriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int i = 0; i < aggregateDescriptorSize; ++i) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        boolean outputEndTime = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Expression pushDownPredicate = null;
        if (isNull == 1) {
            pushDownPredicate = Expression.deserialize(byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedSeriesAggregationScanNode(planNodeId, alignedPath, aggregationDescriptorList, scanOrder, outputEndTime, pushDownPredicate, groupByTimeParameter, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedSeriesAggregationScanNode that = (AlignedSeriesAggregationScanNode)o;
        return this.alignedPath.equals((Object)that.alignedPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.alignedPath, this.regionReplicaSet);
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.getAlignedPath();
    }

    public String toString() {
        return String.format("AlignedSeriesAggregationScanNode-%s:[SeriesPath: %s, Descriptor: %s, DataRegion: %s]", this.getPlanNodeId(), this.getAlignedPath().getFormattedString(), this.getAggregationDescriptorList(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }
}

