/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastQueryTransformNode
extends SingleChildProcessNode {
    private final String viewPath;
    private final String dataType;

    public LastQueryTransformNode(PlanNodeId id, String viewPath, String dataType) {
        super(id);
        this.viewPath = viewPath;
        this.dataType = dataType;
    }

    public LastQueryTransformNode(PlanNodeId id, PlanNode aggNode, String viewPath, String dataType) {
        super(id, aggNode);
        this.viewPath = viewPath;
        this.dataType = dataType;
    }

    @Override
    public PlanNode clone() {
        return new LastQueryTransformNode(this.getPlanNodeId(), this.viewPath, this.dataType);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_TRANSFORM.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.viewPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.dataType, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_TRANSFORM.serialize(stream);
        ReadWriteIOUtils.write((String)this.viewPath, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.dataType, (OutputStream)stream);
    }

    public static LastQueryTransformNode deserialize(ByteBuffer byteBuffer) {
        String viewPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        String dataType = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryTransformNode(planNodeId, viewPath, dataType);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryTransform(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryTransformNode that = (LastQueryTransformNode)o;
        return this.viewPath.equals(that.viewPath) && this.dataType.equals(that.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.viewPath, this.dataType);
    }

    public String toString() {
        return String.format("LastQueryTransformNode-%s:[ViewPath: %s, DataType: %s]", this.getPlanNodeId(), this.viewPath, this.dataType);
    }

    public String getViewPath() {
        return this.viewPath;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getOutputSymbolForSort() {
        return this.viewPath;
    }
}

