/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.previous;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFillFilter;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;

public class BinaryPreviousFill
implements IFill {
    private Binary value;
    private long previousTime;
    private boolean previousIsNull = true;
    private final IFillFilter filter;

    public BinaryPreviousFill(IFillFilter filter) {
        this.filter = filter;
    }

    @Override
    public Column fill(TimeColumn timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            this.previousIsNull = false;
            this.previousTime = timeColumn.getLong(size - 1);
            this.value = valueColumn.getBinary(size - 1);
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            if (this.previousIsNull) {
                return new RunLengthEncodedColumn((Column)BinaryColumnBuilder.NULL_VALUE_BLOCK, size);
            }
            if (this.filter.needFill(timeColumn.getLong(size - 1), this.previousTime)) {
                return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.empty(), new Binary[]{this.value}), size);
            }
        }
        Binary[] array = new Binary[size];
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                if (this.previousIsNull || !this.filter.needFill(timeColumn.getLong(i), this.previousTime)) {
                    isNull[i] = true;
                    hasNullValue = true;
                    continue;
                }
                array[i] = this.value;
                continue;
            }
            array[i] = valueColumn.getBinary(i);
            this.previousTime = timeColumn.getLong(i);
            this.value = array[i];
            this.previousIsNull = false;
        }
        if (hasNullValue) {
            return new BinaryColumn(size, Optional.of(isNull), array);
        }
        return new BinaryColumn(size, Optional.empty(), array);
    }
}

