/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeInfo {
    private static final Logger logger = LoggerFactory.getLogger(ConfigNodeInfo.class);
    private static final String CONFIG_NODE_LIST = "config_node_list";
    private static final String PROPERTIES_FILE_NAME = "system.properties";
    private final ReentrantReadWriteLock configNodeInfoReadWriteLock = new ReentrantReadWriteLock();
    private final Set<TEndPoint> onlineConfigNodes = new HashSet<TEndPoint>();
    public static final ConfigRegionId CONFIG_REGION_ID = new ConfigRegionId(0);
    private final File propertiesFile = SystemFileFactory.INSTANCE.getFile(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "system.properties");

    private ConfigNodeInfo() {
    }

    public static void reinitializeStatics() {
        ConfigNodeInfoHolder.INSTANCE = new ConfigNodeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigNodeList(List<TEndPoint> latestConfigNodes) {
        long startTime = System.currentTimeMillis();
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            if (this.onlineConfigNodes.containsAll(latestConfigNodes) && new HashSet<TEndPoint>(latestConfigNodes).containsAll(this.onlineConfigNodes)) {
                return;
            }
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            this.onlineConfigNodes.clear();
            this.onlineConfigNodes.addAll(latestConfigNodes);
            this.storeConfigNode();
            long endTime = System.currentTimeMillis();
            logger.info("Update ConfigNode Successfully: {}, which takes {} ms.", this.onlineConfigNodes, (Object)(endTime - startTime));
        }
        catch (IOException e) {
            logger.error("Update ConfigNode failed.", (Throwable)e);
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    private void storeConfigNode() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);){
            properties.load(inputStream);
        }
        properties.setProperty(CONFIG_NODE_LIST, NodeUrlUtils.convertTEndPointUrls(new ArrayList<TEndPoint>(this.onlineConfigNodes)));
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.propertiesFile);){
            properties.store(fileOutputStream, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfigNodeList() {
        long startTime = System.currentTimeMillis();
        try {
            this.configNodeInfoReadWriteLock.writeLock().lock();
            Properties properties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);){
                properties.load(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (properties.containsKey(CONFIG_NODE_LIST)) {
                this.onlineConfigNodes.clear();
                this.onlineConfigNodes.addAll(NodeUrlUtils.parseTEndPointUrls((String)properties.getProperty(CONFIG_NODE_LIST)));
            }
            long endTime = System.currentTimeMillis();
            logger.info("Load ConfigNode successfully: {}, which takes {} ms.", this.onlineConfigNodes, (Object)(endTime - startTime));
        }
        catch (BadNodeUrlException e) {
            logger.error("Cannot parse config node list in system.properties");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    public List<TEndPoint> getLatestConfigNodes() {
        ArrayList<TEndPoint> result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TEndPoint>(this.onlineConfigNodes);
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public static ConfigNodeInfo getInstance() {
        return ConfigNodeInfoHolder.INSTANCE;
    }

    private static class ConfigNodeInfoHolder {
        private static ConfigNodeInfo INSTANCE = new ConfigNodeInfo();

        private ConfigNodeInfoHolder() {
        }
    }
}

