/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.consensus.request.read.ttl.ShowTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.response.ttl.ShowTTLResp;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.persistence.TTLInfo;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TTLManager.class);
    private final IManager configManager;
    private final TTLInfo ttlInfo;
    private static final int ttlCountThreshold = CommonDescriptor.getInstance().getConfig().getTTlRuleCapacity();

    public TTLManager(IManager configManager, TTLInfo ttlInfo) {
        this.configManager = configManager;
        this.ttlInfo = ttlInfo;
    }

    public TSStatus setTTL(DatabaseSchemaPlan databaseSchemaPlan, boolean isGeneratedByPipe) throws IllegalPathException {
        long ttl = databaseSchemaPlan.getSchema().getTTL();
        if (ttl < 0L) {
            TSStatus errorStatus = new TSStatus(TSStatusCode.TTL_CONFIG_ERROR.getStatusCode());
            errorStatus.setMessage("The TTL should be positive.");
            return errorStatus;
        }
        SetTTLPlan setTTLPlan = new SetTTLPlan(PathUtils.splitPathToDetachedNodes((String)databaseSchemaPlan.getSchema().getName()), ttl);
        setTTLPlan.setDataBase(true);
        return this.configManager.getProcedureManager().setTTL(setTTLPlan, isGeneratedByPipe);
    }

    public TSStatus setTTL(SetTTLPlan setTTLPlan, boolean isGeneratedByPipe) {
        PartialPath path = new PartialPath(setTTLPlan.getPathPattern());
        if (!this.checkIsPathValidated(path)) {
            TSStatus errorStatus = new TSStatus(TSStatusCode.ILLEGAL_PARAMETER.getStatusCode());
            errorStatus.setMessage(String.format("Illegal pattern path: %s, pattern path should end with **, otherwise, it should be a specific database or device path without *", path.getFullPath()));
            return errorStatus;
        }
        if (setTTLPlan.getTTL() < 0L) {
            TSStatus errorStatus = new TSStatus(TSStatusCode.TTL_CONFIG_ERROR.getStatusCode());
            errorStatus.setMessage("The TTL should be positive.");
            return errorStatus;
        }
        setTTLPlan.setDataBase(this.configManager.getPartitionManager().isDatabaseExist(path.getFullPath()));
        return this.configManager.getProcedureManager().setTTL(setTTLPlan, isGeneratedByPipe);
    }

    public TSStatus unsetTTL(SetTTLPlan setTTLPlan, boolean isGeneratedByPipe) {
        PartialPath path = new PartialPath(setTTLPlan.getPathPattern());
        if (!this.checkIsPathValidated(path)) {
            TSStatus errorStatus = new TSStatus(TSStatusCode.ILLEGAL_PARAMETER.getStatusCode());
            errorStatus.setMessage(String.format("Illegal pattern path: %s, pattern path should end with **, otherwise, it should be a specific database or device path without *", path.getFullPath()));
            return errorStatus;
        }
        setTTLPlan.setDataBase(this.configManager.getPartitionManager().isDatabaseExist(path.getFullPath()));
        return this.configManager.getProcedureManager().setTTL(setTTLPlan, isGeneratedByPipe);
    }

    public DataSet showTTL(ShowTTLPlan showTTLPlan) {
        try {
            return this.configManager.getConsensusManager().read(showTTLPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus tsStatus = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            tsStatus.setMessage(e.getMessage());
            ShowTTLResp resp = new ShowTTLResp();
            resp.setStatus(tsStatus);
            return resp;
        }
    }

    public Map<String, Long> getAllTTL() {
        return ((ShowTTLResp)this.showTTL(new ShowTTLPlan())).getPathTTLMap();
    }

    public int getTTLCount() {
        return this.ttlInfo.getTTLCount();
    }

    public long getDatabaseMaxTTL(String database) {
        return this.ttlInfo.getDatabaseMaxTTL(database);
    }

    public void setTTL(Map<String, Long> databaseTTLMap) throws IllegalPathException {
        this.ttlInfo.setTTL(databaseTTLMap);
    }

    private boolean checkIsPathValidated(PartialPath path) {
        return path.isPrefixPath() || !path.getFullPath().contains("*");
    }
}

