/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UpdateTriggerStateInTablePlan
extends ConfigPhysicalPlan {
    private String triggerName;
    private TTriggerState triggerState;

    public UpdateTriggerStateInTablePlan() {
        super(ConfigPhysicalPlanType.UpdateTriggerStateInTable);
    }

    public UpdateTriggerStateInTablePlan(String triggerName, TTriggerState triggerState) {
        super(ConfigPhysicalPlanType.UpdateTriggerStateInTable);
        this.triggerName = triggerName;
        this.triggerState = triggerState;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public TTriggerState getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(TTriggerState triggerState) {
        this.triggerState = triggerState;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.triggerName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.triggerState.getValue(), (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.triggerName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.triggerState = TTriggerState.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)buffer));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateTriggerStateInTablePlan that = (UpdateTriggerStateInTablePlan)o;
        return Objects.equals(this.triggerName, that.triggerName) && this.triggerState == that.triggerState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.triggerName, this.triggerState);
    }
}

