/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.state.schema.AlterLogicalViewState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.metadata.view.ViewNotExistException;
import org.apache.iotdb.mpp.rpc.thrift.TAlterViewReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterLogicalViewProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, AlterLogicalViewState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlterLogicalViewProcedure.class);
    private String queryId;
    private Map<PartialPath, ViewExpression> viewPathToSourceMap;
    private transient PathPatternTree pathPatternTree;
    private transient ByteBuffer patternTreeBytes;

    public AlterLogicalViewProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public AlterLogicalViewProcedure(String queryId, Map<PartialPath, ViewExpression> viewPathToSourceMap, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.viewPathToSourceMap = viewPathToSourceMap;
        this.generatePathPatternTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AlterLogicalViewState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CLEAN_DATANODE_SCHEMA_CACHE: {
                    LOGGER.info("Invalidate cache of view {}", this.viewPathToSourceMap.keySet());
                    this.invalidateCache(env);
                    this.setNextState(AlterLogicalViewState.ALTER_LOGICAL_VIEW);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
                    return flow;
                }
                case ALTER_LOGICAL_VIEW: {
                    LOGGER.info("Alter view {}", this.viewPathToSourceMap.keySet());
                    try {
                        this.alterLogicalView(env);
                    }
                    catch (ProcedureException e) {
                        this.setFailure(e);
                    }
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("AlterLogicalView-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.patternTreeBytes), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schemaengine cache of view {}", this.viewPathToSourceMap.keySet());
            this.setFailure(new ProcedureException(new MetadataException("Invalidate view schemaengine cache failed")));
            return;
        }
    }

    private void alterLogicalView(ConfigNodeProcedureEnv env) throws ProcedureException {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.pathPatternTree);
        HashMap<TConsensusGroupId, Map> schemaRegionRequestMap = new HashMap<TConsensusGroupId, Map>();
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            schemaRegionRequestMap.computeIfAbsent(this.getBelongedSchemaRegion(env, entry.getKey()), k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        AlterLogicalViewRegionTaskExecutor<TAlterViewReq> regionTaskExecutor = new AlterLogicalViewRegionTaskExecutor<TAlterViewReq>("Alter view", env, targetSchemaRegionGroup, CnToDnAsyncRequestType.ALTER_VIEW, (dataNodeLocation, consensusGroupIdList) -> {
            TAlterViewReq req = new TAlterViewReq().setIsGeneratedByPipe(this.isGeneratedByPipe);
            req.setSchemaRegionIdList(consensusGroupIdList);
            ArrayList<ByteBuffer> viewMapBinaryList = new ArrayList<ByteBuffer>();
            for (TConsensusGroupId consensusGroupId : consensusGroupIdList) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Map viewMap = (Map)schemaRegionRequestMap.get(consensusGroupId);
                try {
                    ReadWriteIOUtils.write((int)viewMap.size(), (OutputStream)stream);
                    for (Map.Entry viewEntry : viewMap.entrySet()) {
                        ((PartialPath)viewEntry.getKey()).serialize((OutputStream)stream);
                        ViewExpression.serialize((ViewExpression)((ViewExpression)viewEntry.getValue()), (OutputStream)stream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                viewMapBinaryList.add(ByteBuffer.wrap(stream.toByteArray()));
            }
            req.setViewBinaryList(viewMapBinaryList);
            return req;
        });
        regionTaskExecutor.execute();
        if (this.isFailed()) {
            return;
        }
        this.invalidateCache(env);
    }

    private TConsensusGroupId getBelongedSchemaRegion(ConfigNodeProcedureEnv env, PartialPath viewPath) throws ProcedureException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(viewPath);
        patternTree.constructTree();
        Map schemaPartitionTable = env.getConfigManager().getSchemaPartition((PathPatternTree)patternTree).schemaPartitionTable;
        if (schemaPartitionTable.isEmpty()) {
            throw new ProcedureException((Throwable)new ViewNotExistException(viewPath.getFullPath()));
        }
        Map slotMap = (Map)schemaPartitionTable.values().iterator().next();
        if (slotMap.isEmpty()) {
            throw new ProcedureException((Throwable)new ViewNotExistException(viewPath.getFullPath()));
        }
        return (TConsensusGroupId)slotMap.values().iterator().next();
    }

    @Override
    protected boolean isRollbackSupported(AlterLogicalViewState alterLogicalViewState) {
        return true;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AlterLogicalViewState alterLogicalViewState) throws IOException, InterruptedException, ProcedureException {
        if (alterLogicalViewState == AlterLogicalViewState.CLEAN_DATANODE_SCHEMA_CACHE) {
            this.invalidateCache(env);
        }
    }

    @Override
    protected AlterLogicalViewState getState(int stateId) {
        return AlterLogicalViewState.values()[stateId];
    }

    @Override
    protected int getStateId(AlterLogicalViewState alterLogicalViewState) {
        return alterLogicalViewState.ordinal();
    }

    @Override
    protected AlterLogicalViewState getInitialState() {
        return AlterLogicalViewState.CLEAN_DATANODE_SCHEMA_CACHE;
    }

    public String getQueryId() {
        return this.queryId;
    }

    private void generatePathPatternTree() {
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath path : this.viewPathToSourceMap.keySet()) {
            patternTree.appendFullPath(path);
        }
        patternTree.constructTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pathPatternTree = patternTree;
        this.patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_ALTER_LOGICAL_VIEW_PROCEDURE.getTypeCode() : ProcedureType.ALTER_LOGICAL_VIEW_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.viewPathToSourceMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ViewExpression.serialize((ViewExpression)entry.getValue(), (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        HashMap<PartialPath, ViewExpression> viewPathToSourceMap = new HashMap<PartialPath, ViewExpression>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            ViewExpression viewExpression = ViewExpression.deserialize((ByteBuffer)byteBuffer);
            viewPathToSourceMap.put(path, viewExpression);
        }
        this.viewPathToSourceMap = viewPathToSourceMap;
        this.generatePathPatternTree();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterLogicalViewProcedure)) {
            return false;
        }
        AlterLogicalViewProcedure that = (AlterLogicalViewProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && Objects.equals(this.getCycles(), that.getCycles()) && Objects.equals(this.isGeneratedByPipe, that.isGeneratedByPipe) && Objects.equals(this.queryId, that.queryId) && Objects.equals(this.viewPathToSourceMap, that.viewPathToSourceMap);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.queryId, this.viewPathToSourceMap);
    }

    private class AlterLogicalViewRegionTaskExecutor<Q>
    extends DataNodeRegionTaskExecutor<Q, TSStatus> {
        private final String taskName;
        private final List<TSStatus> failureStatusList;

        AlterLogicalViewRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, CnToDnAsyncRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.failureStatusList = new ArrayList<TSStatus>();
            this.taskName = taskName;
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return failedRegionList;
            }
            if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatusList = response.getSubStatus();
                for (int i = 0; i < subStatusList.size(); ++i) {
                    TSStatus subStatus = (TSStatus)subStatusList.get(i);
                    if (subStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    if (subStatus.getCode() == TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()) {
                        failedRegionList.add(consensusGroupIdList.get(i));
                        continue;
                    }
                    this.collectFailure(subStatus);
                    this.interruptTask();
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        private void collectFailure(TSStatus failureStatus) {
            if (failureStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                this.failureStatusList.addAll(failureStatus.getSubStatus());
            } else {
                this.failureStatusList.add(failureStatus);
            }
            if (this.failureStatusList.size() == 1) {
                AlterLogicalViewProcedure.this.setFailure(new ProcedureException((Throwable)new IoTDBException(this.failureStatusList.get(0).getMessage(), this.failureStatusList.get(0).getCode())));
            } else {
                AlterLogicalViewProcedure.this.setFailure(new ProcedureException((Throwable)new BatchProcessException(this.failureStatusList.toArray(new TSStatus[0]))));
            }
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            AlterLogicalViewProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Alter view %s failed when [%s] because failed to execute in all replicaset of schemaRegion %s. Failure nodes: %s", AlterLogicalViewProcedure.this.viewPathToSourceMap.keySet(), this.taskName, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

