/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.Vocabulary;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.OSUtils;
import org.jline.widget.AutosuggestionWidgets;

public class JlineUtils {
    public static final Pattern SQL_KEYWORD_PATTERN = Pattern.compile("([A-Z_]+)");
    public static final Set<String> SQL_KEYWORDS = IntStream.range(0, SqlLexer.VOCABULARY.getMaxTokenType()).mapToObj(arg_0 -> ((Vocabulary)SqlLexer.VOCABULARY).getDisplayName(arg_0)).filter(Objects::nonNull).filter(w -> SQL_KEYWORD_PATTERN.matcher((CharSequence)w).matches()).collect(Collectors.toSet());

    private JlineUtils() {
    }

    public static LineReader getLineReader(CliContext ctx, String username, String host, String port) throws IOException {
        Logger.getLogger("org.jline").setLevel(Level.OFF);
        Terminal terminal = ctx.getIn() == System.in && ctx.getOut() == System.out ? TerminalBuilder.builder().dumb(true).build() : TerminalBuilder.builder().streams(ctx.getIn(), (OutputStream)ctx.getOut()).dumb(true).build();
        if (terminal.getWidth() == 0 || terminal.getHeight() == 0) {
            terminal.setSize(new Size(120, 40));
        }
        Thread executeThread = Thread.currentThread();
        terminal.handle(Terminal.Signal.INT, signal -> executeThread.interrupt());
        LineReaderBuilder builder = LineReaderBuilder.builder();
        builder.terminal(terminal);
        if (!ctx.isDisableCliHistory()) {
            String historyFile = ".iotdb_history";
            String historyFilePath = System.getProperty("user.home") + File.separator + historyFile + "-" + host.hashCode() + "-" + port + "-" + username.hashCode();
            builder.variable("history-file", (Object)new File(historyFilePath));
            builder.variable("history-file-size", (Object)1000);
            builder.variable("history-size", (Object)1000);
        }
        builder.completer((Completer)new StringsCompleter(SQL_KEYWORDS));
        builder.option(LineReader.Option.CASE_INSENSITIVE_SEARCH, true);
        builder.option(LineReader.Option.CASE_INSENSITIVE, true);
        builder.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        DefaultParser parser = new DefaultParser();
        builder.parser((Parser)parser);
        LineReader lineReader = builder.build();
        if (OSUtils.IS_WINDOWS) {
            lineReader.setVariable("blink-matching-paren", (Object)0);
        }
        AutosuggestionWidgets autosuggestionWidgets = new AutosuggestionWidgets(lineReader);
        autosuggestionWidgets.enable();
        return lineReader;
    }
}

