/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.config;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.it.env.cluster.EnvUtils;
import org.apache.iotdb.it.env.cluster.config.MppBaseConfig;
import org.apache.iotdb.itbase.env.CommonConfig;

public class MppCommonConfig
extends MppBaseConfig
implements CommonConfig {
    public MppCommonConfig() {
        this.setProperty("disk_space_warning_threshold", String.valueOf(0.01));
    }

    protected MppCommonConfig(String filePath) throws IOException {
        super(filePath);
    }

    @Override
    public void updateProperties(MppBaseConfig persistentConfig) {
        if (!(persistentConfig instanceof MppCommonConfig)) {
            throw new UnsupportedOperationException("MppCommonConfig can't be override by an instance of " + persistentConfig.getClass().getCanonicalName());
        }
        super.updateProperties(persistentConfig);
    }

    @Override
    public MppBaseConfig emptyClone() {
        return new MppCommonConfig();
    }

    @Override
    public CommonConfig setMaxNumberOfPointsInPage(int maxNumberOfPointsInPage) {
        this.setProperty("max_number_of_points_in_page", String.valueOf(maxNumberOfPointsInPage));
        return this;
    }

    @Override
    public CommonConfig setPageSizeInByte(int pageSizeInByte) {
        this.setProperty("page_size_in_byte", String.valueOf(pageSizeInByte));
        return this;
    }

    @Override
    public CommonConfig setGroupSizeInByte(int groupSizeInByte) {
        this.setProperty("group_size_in_byte", String.valueOf(groupSizeInByte));
        return this;
    }

    @Override
    public CommonConfig setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.setProperty("memtable_size_threshold", String.valueOf(memtableSizeThreshold));
        return this;
    }

    @Override
    public CommonConfig setPartitionInterval(long partitionInterval) {
        this.setProperty("time_partition_interval", String.valueOf(partitionInterval));
        return this;
    }

    @Override
    public CommonConfig setCompressor(String compressor) {
        this.setProperty("compressor", compressor);
        return this;
    }

    @Override
    public CommonConfig setEncryptType(String encryptType) {
        this.setProperty("encrypt_type", encryptType);
        return this;
    }

    @Override
    public CommonConfig setEncryptKeyPath(String encryptKeyPath) {
        this.setProperty("encrypt_key_path", encryptKeyPath);
        return this;
    }

    @Override
    public CommonConfig setUdfMemoryBudgetInMB(float udfCollectorMemoryBudgetInMB) {
        this.setProperty("udf_memory_budget_in_mb", String.valueOf(udfCollectorMemoryBudgetInMB * 3.0f));
        return this;
    }

    @Override
    public CommonConfig setEnableSeqSpaceCompaction(boolean enableSeqSpaceCompaction) {
        this.setProperty("enable_seq_space_compaction", String.valueOf(enableSeqSpaceCompaction));
        return this;
    }

    @Override
    public CommonConfig setEnableUnseqSpaceCompaction(boolean enableUnseqSpaceCompaction) {
        this.setProperty("enable_unseq_space_compaction", String.valueOf(enableUnseqSpaceCompaction));
        return this;
    }

    @Override
    public CommonConfig setEnableCrossSpaceCompaction(boolean enableCrossSpaceCompaction) {
        this.setProperty("enable_cross_space_compaction", String.valueOf(enableCrossSpaceCompaction));
        return this;
    }

    @Override
    public CommonConfig setInnerCompactionCandidateFileNum(int maxInnerCompactionCandidateFileNum) {
        this.setProperty("inner_compaction_candidate_file_num", String.valueOf(maxInnerCompactionCandidateFileNum));
        return this;
    }

    @Override
    public CommonConfig setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.setProperty("enable_auto_create_schema", String.valueOf(enableAutoCreateSchema));
        return this;
    }

    @Override
    public CommonConfig setEnableLastCache(boolean lastCacheEnable) {
        this.setProperty("enable_last_cache", String.valueOf(lastCacheEnable));
        return this;
    }

    @Override
    public CommonConfig setPrimitiveArraySize(int primitiveArraySize) {
        this.setProperty("primitive_array_size", String.valueOf(primitiveArraySize));
        return this;
    }

    @Override
    public CommonConfig setTargetChunkPointNum(int targetChunkPointNum) {
        this.setProperty("target_chunk_point_num", String.valueOf(targetChunkPointNum));
        return this;
    }

    @Override
    public CommonConfig setMaxTsBlockLineNumber(int maxTsBlockLineNumber) {
        this.setProperty("max_tsblock_line_number", String.valueOf(maxTsBlockLineNumber));
        return this;
    }

    @Override
    public CommonConfig setConfigRegionRatisRPCLeaderElectionTimeoutMaxMs(int maxMs) {
        this.setProperty("config_node_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(maxMs));
        return this;
    }

    @Override
    public CommonConfig setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.setProperty("config_node_consensus_protocol_class", configNodeConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.setProperty("schema_region_consensus_protocol_class", schemaRegionConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.setProperty("data_region_consensus_protocol_class", dataRegionConsensusProtocolClass);
        return this;
    }

    @Override
    public CommonConfig setIoTConsensusV2Mode(String ioTConsensusV2Mode) {
        this.setProperty("iot_consensus_v2_mode", ioTConsensusV2Mode);
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionGroupExtensionPolicy(String schemaRegionGroupExtensionPolicy) {
        this.setProperty("schema_region_group_extension_policy", schemaRegionGroupExtensionPolicy);
        return this;
    }

    @Override
    public CommonConfig setDefaultSchemaRegionGroupNumPerDatabase(int schemaRegionGroupPerDatabase) {
        this.setProperty("default_schema_region_group_num_per_database", String.valueOf(schemaRegionGroupPerDatabase));
        return this;
    }

    @Override
    public CommonConfig setDataRegionGroupExtensionPolicy(String dataRegionGroupExtensionPolicy) {
        this.setProperty("data_region_group_extension_policy", dataRegionGroupExtensionPolicy);
        return this;
    }

    @Override
    public CommonConfig setDefaultDataRegionGroupNumPerDatabase(int dataRegionGroupPerDatabase) {
        this.setProperty("default_data_region_group_num_per_database", String.valueOf(dataRegionGroupPerDatabase));
        return this;
    }

    @Override
    public CommonConfig setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.setProperty("schema_replication_factor", String.valueOf(schemaReplicationFactor));
        return this;
    }

    @Override
    public CommonConfig setDataReplicationFactor(int dataReplicationFactor) {
        this.setProperty("data_replication_factor", String.valueOf(dataReplicationFactor));
        return this;
    }

    @Override
    public CommonConfig setTimePartitionInterval(long timePartitionInterval) {
        this.setProperty("time_partition_interval", String.valueOf(timePartitionInterval));
        return this;
    }

    @Override
    public CommonConfig setTTLCheckInterval(long ttlCheckInterval) {
        this.setProperty("ttl_check_interval", String.valueOf(ttlCheckInterval));
        return this;
    }

    @Override
    public CommonConfig setTimePartitionOrigin(long timePartitionOrigin) {
        this.setProperty("time_partition_origin", String.valueOf(timePartitionOrigin));
        return this;
    }

    @Override
    public CommonConfig setTimestampPrecision(String timestampPrecision) {
        this.setProperty("timestamp_precision", timestampPrecision);
        return this;
    }

    @Override
    public TimeUnit getTimestampPrecision() {
        String precision;
        switch (precision = this.properties.getProperty("timestamp_precision", "ms")) {
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "us": {
                return TimeUnit.MICROSECONDS;
            }
            case "ns": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException(precision);
    }

    @Override
    public CommonConfig setTimestampPrecisionCheckEnabled(boolean timestampPrecisionCheckEnabled) {
        this.setProperty("timestamp_precision_check_enabled", String.valueOf(timestampPrecisionCheckEnabled));
        return this;
    }

    @Override
    public CommonConfig setEnableMemControl(boolean enableMemControl) {
        this.setProperty("enable_mem_control", String.valueOf(enableMemControl));
        return this;
    }

    @Override
    public CommonConfig setConfigNodeRatisSnapshotTriggerThreshold(int ratisSnapshotTriggerThreshold) {
        this.setProperty("config_node_ratis_snapshot_trigger_threshold", String.valueOf(ratisSnapshotTriggerThreshold));
        return this;
    }

    @Override
    public CommonConfig setMaxDegreeOfIndexNode(int maxDegreeOfIndexNode) {
        this.setProperty("max_degree_of_index_node", String.valueOf(maxDegreeOfIndexNode));
        return this;
    }

    @Override
    public CommonConfig setEnableMQTTService(boolean enableMQTTService) {
        this.setProperty("enable_mqtt_service", String.valueOf(enableMQTTService));
        return this;
    }

    @Override
    public CommonConfig setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.setProperty("mqtt_payload_formatter", String.valueOf(mqttPayloadFormatter));
        return this;
    }

    @Override
    public CommonConfig setSchemaEngineMode(String schemaEngineMode) {
        this.setProperty("schema_engine_mode", schemaEngineMode);
        return this;
    }

    @Override
    public CommonConfig setSelectIntoInsertTabletPlanRowLimit(int selectIntoInsertTabletPlanRowLimit) {
        this.setProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(selectIntoInsertTabletPlanRowLimit));
        return this;
    }

    @Override
    public CommonConfig setEnableAutoLeaderBalanceForRatisConsensus(boolean enableAutoLeaderBalanceForRatisConsensus) {
        this.setProperty("enable_auto_leader_balance_for_ratis_consensus", String.valueOf(enableAutoLeaderBalanceForRatisConsensus));
        return this;
    }

    @Override
    public CommonConfig setEnableAutoLeaderBalanceForIoTConsensus(boolean enableAutoLeaderBalanceForIoTConsensus) {
        this.setProperty("enable_auto_leader_balance_for_iot_consensus", String.valueOf(enableAutoLeaderBalanceForIoTConsensus));
        return this;
    }

    @Override
    public CommonConfig setQueryThreadCount(int queryThreadCount) {
        if (queryThreadCount <= 0) {
            queryThreadCount = Runtime.getRuntime().availableProcessors();
        }
        this.setProperty("query_thread_count", String.valueOf(queryThreadCount));
        return this;
    }

    @Override
    public CommonConfig setWalBufferSize(int walBufferSize) {
        this.setProperty("wal_buffer_size_in_byte", String.valueOf(walBufferSize));
        return this;
    }

    @Override
    public CommonConfig setDegreeOfParallelism(int degreeOfParallelism) {
        this.setProperty("degree_of_query_parallelism", String.valueOf(degreeOfParallelism));
        return this;
    }

    @Override
    public CommonConfig setDataRatisTriggerSnapshotThreshold(long threshold) {
        this.setProperty("data_region_ratis_snapshot_trigger_threshold", String.valueOf(threshold));
        return this;
    }

    @Override
    public CommonConfig setSeriesSlotNum(int seriesSlotNum) {
        this.setProperty("series_slot_num", String.valueOf(seriesSlotNum));
        return this;
    }

    @Override
    public CommonConfig setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.setProperty("series_partition_executor_class", seriesPartitionExecutorClass);
        return this;
    }

    @Override
    public CommonConfig setSchemaMemoryAllocate(String schemaMemoryAllocate) {
        this.setProperty("schema_memory_proportion", String.valueOf(schemaMemoryAllocate));
        return this;
    }

    @Override
    public CommonConfig setWriteMemoryProportion(String writeMemoryProportion) {
        this.setProperty("write_memory_proportion", writeMemoryProportion);
        return this;
    }

    @Override
    public CommonConfig setQuotaEnable(boolean quotaEnable) {
        this.setProperty("quota_enable", String.valueOf(quotaEnable));
        return this;
    }

    @Override
    public CommonConfig setSortBufferSize(long sortBufferSize) {
        this.setProperty("sort_buffer_size_in_bytes", String.valueOf(sortBufferSize));
        return this;
    }

    @Override
    public CommonConfig setMaxTsBlockSizeInByte(long maxTsBlockSizeInByte) {
        this.setProperty("max_tsblock_size_in_bytes", String.valueOf(maxTsBlockSizeInByte));
        return this;
    }

    @Override
    public CommonConfig setClusterTimeseriesLimitThreshold(long clusterSchemaLimitThreshold) {
        this.setProperty("cluster_timeseries_limit_threshold", String.valueOf(clusterSchemaLimitThreshold));
        return this;
    }

    @Override
    public CommonConfig setClusterDeviceLimitThreshold(long clusterDeviceLimitThreshold) {
        this.setProperty("cluster_device_limit_threshold", String.valueOf(clusterDeviceLimitThreshold));
        return this;
    }

    @Override
    public CommonConfig setDatabaseLimitThreshold(long databaseLimitThreshold) {
        this.setProperty("database_limit_threshold", String.valueOf(databaseLimitThreshold));
        return this;
    }

    @Override
    public CommonConfig setDataRegionPerDataNode(double dataRegionPerDataNode) {
        this.setProperty("data_region_per_data_node", String.valueOf(dataRegionPerDataNode));
        return this;
    }

    @Override
    public CommonConfig setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.setProperty("schema_region_per_data_node", String.valueOf(schemaRegionPerDataNode));
        return this;
    }

    @Override
    public CommonConfig setPipeMemoryManagementEnabled(boolean pipeMemoryManagementEnabled) {
        this.setProperty("pipe_memory_management_enabled", String.valueOf(pipeMemoryManagementEnabled));
        return this;
    }

    @Override
    public CommonConfig setIsPipeEnableMemoryCheck(boolean isPipeEnableMemoryCheck) {
        this.setProperty("pipe_enable_memory_checked", String.valueOf(isPipeEnableMemoryCheck));
        return this;
    }

    @Override
    public CommonConfig setPipeAirGapReceiverEnabled(boolean isPipeAirGapReceiverEnabled) {
        this.setProperty("pipe_air_gap_receiver_enabled", String.valueOf(isPipeAirGapReceiverEnabled));
        return this;
    }

    @Override
    public CommonConfig setDriverTaskExecutionTimeSliceInMs(long driverTaskExecutionTimeSliceInMs) {
        this.setProperty("driver_task_execution_time_slice_in_ms", String.valueOf(driverTaskExecutionTimeSliceInMs));
        return this;
    }

    @Override
    public CommonConfig setWalMode(String walMode) {
        this.setProperty("wal_mode", walMode);
        return this;
    }

    @Override
    public CommonConfig setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.setProperty("tag_attribute_total_size", String.valueOf(tagAttributeTotalSize));
        return this;
    }

    @Override
    public CommonConfig setDnConnectionTimeoutMs(int connectionTimeoutMs) {
        this.setProperty("dn_connection_timeout_ms", String.valueOf(connectionTimeoutMs));
        return this;
    }

    @Override
    public CommonConfig setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(int pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
        this.setProperty("pipe_heartbeat_interval_seconds_for_collecting_pipe_meta", String.valueOf(pipeHeartbeatIntervalSecondsForCollectingPipeMeta));
        return this;
    }

    @Override
    public CommonConfig setPipeMetaSyncerInitialSyncDelayMinutes(long pipeMetaSyncerInitialSyncDelayMinutes) {
        this.setProperty("pipe_meta_syncer_initial_sync_delay_minutes", String.valueOf(pipeMetaSyncerInitialSyncDelayMinutes));
        return this;
    }

    @Override
    public CommonConfig setPipeMetaSyncerSyncIntervalMinutes(long pipeMetaSyncerSyncIntervalMinutes) {
        this.setProperty("pipe_meta_syncer_sync_interval_minutes", String.valueOf(pipeMetaSyncerSyncIntervalMinutes));
        return this;
    }

    @Override
    public CommonConfig setPipeConnectorRequestSliceThresholdBytes(int pipeConnectorRequestSliceThresholdBytes) {
        this.setProperty("pipe_connector_request_slice_threshold_bytes", String.valueOf(pipeConnectorRequestSliceThresholdBytes));
        return this;
    }

    @Override
    public CommonConfig setQueryMemoryProportion(String queryMemoryProportion) {
        this.setProperty("chunk_timeseriesmeta_free_memory_proportion", queryMemoryProportion);
        return this;
    }

    @Override
    public CommonConfig setSubscriptionPrefetchTsFileBatchMaxDelayInMs(int subscriptionPrefetchTsFileBatchMaxDelayInMs) {
        this.setProperty("subscription_prefetch_ts_file_batch_max_delay_in_ms", String.valueOf(subscriptionPrefetchTsFileBatchMaxDelayInMs));
        return this;
    }

    @Override
    public CommonConfig setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(int subscriptionPrefetchTsFileBatchMaxSizeInBytes) {
        this.setProperty("subscription_prefetch_ts_file_batch_max_size_in_bytes", String.valueOf(subscriptionPrefetchTsFileBatchMaxSizeInBytes));
        return this;
    }

    @Override
    public CommonConfig setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.setProperty("subscription_enabled", String.valueOf(subscriptionEnabled));
        return this;
    }

    @Override
    public CommonConfig setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.setProperty("default_storage_group_level", String.valueOf(defaultStorageGroupLevel));
        return this;
    }

    @Override
    public CommonConfig setDatanodeMemoryProportion(String datanodeMemoryProportion) {
        this.setProperty("datanode_memory_proportion", datanodeMemoryProportion);
        return this;
    }

    public String getClusterConfigStr() {
        return EnvUtils.fromConsensusFullNameToAbbr(this.properties.getProperty("config_node_consensus_protocol_class")) + "-" + EnvUtils.fromConsensusFullNameToAbbr(this.properties.getProperty("schema_region_consensus_protocol_class")) + "-" + EnvUtils.fromConsensusFullNameToAbbr(this.properties.getProperty("data_region_consensus_protocol_class")) + "-" + this.properties.getProperty("schema_replication_factor") + "-" + this.properties.getProperty("data_replication_factor");
    }
}

