/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster.config;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.it.env.cluster.config.MppBaseConfig;
import org.apache.iotdb.itbase.env.DataNodeConfig;

public class MppDataNodeConfig
extends MppBaseConfig
implements DataNodeConfig {
    public MppDataNodeConfig() {
    }

    public MppDataNodeConfig(String filePath) throws IOException {
        super(filePath);
    }

    @Override
    public MppBaseConfig emptyClone() {
        return new MppDataNodeConfig();
    }

    @Override
    public void updateProperties(MppBaseConfig persistentConfig) {
        if (!(persistentConfig instanceof MppDataNodeConfig)) {
            throw new UnsupportedOperationException("MppDataNodeConfig can't be override by an instance of " + persistentConfig.getClass().getCanonicalName());
        }
        super.updateProperties(persistentConfig);
    }

    @Override
    public DataNodeConfig setMetricReporterType(List<String> metricReporterTypes) {
        this.properties.setProperty("dn_metric_reporter_list", String.join((CharSequence)",", metricReporterTypes));
        return this;
    }

    @Override
    public DataNodeConfig setMetricPrometheusReporterUsername(String username) {
        this.properties.setProperty("metric_prometheus_reporter_username", username);
        return this;
    }

    @Override
    public DataNodeConfig setMetricPrometheusReporterPassword(String password) {
        this.properties.setProperty("metric_prometheus_reporter_password", password);
        return this;
    }

    @Override
    public DataNodeConfig setEnableRestService(boolean enableRestService) {
        this.properties.setProperty("enable_rest_service", String.valueOf(enableRestService));
        return this;
    }

    @Override
    public DataNodeConfig setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.properties.setProperty("dn_connection_timeout_ms", String.valueOf(connectionTimeoutInMS));
        return this;
    }

    @Override
    public DataNodeConfig setLoadTsFileAnalyzeSchemaMemorySizeInBytes(long loadTsFileAnalyzeSchemaMemorySizeInBytes) {
        this.properties.setProperty("load_tsfile_analyze_schema_memory_size_in_bytes", String.valueOf(loadTsFileAnalyzeSchemaMemorySizeInBytes));
        return this;
    }

    @Override
    public DataNodeConfig setCompactionScheduleInterval(long compactionScheduleInterval) {
        this.properties.setProperty("compaction_schedule_interval_in_ms", String.valueOf(compactionScheduleInterval));
        return this;
    }

    @Override
    public DataNodeConfig setEnableMQTTService(boolean enableMQTTService) {
        this.setProperty("enable_mqtt_service", String.valueOf(enableMQTTService));
        return this;
    }

    @Override
    public DataNodeConfig setMqttPayloadFormatter(String mqttPayloadFormatter) {
        this.setProperty("mqtt_payload_formatter", String.valueOf(mqttPayloadFormatter));
        return this;
    }
}

