/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.runtime;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.iotdb.itbase.exception.InconsistentDataException;
import org.slf4j.Logger;

public abstract class RequestDelegate<T> {
    private static final Logger logger = IoTDBTestLogger.logger;
    private final List<String> endpoints;
    private final List<Callable<T>> requests = new ArrayList<Callable<T>>();

    public RequestDelegate(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public final void addRequest(Callable<T> request) {
        this.requests.add(request);
    }

    public abstract List<T> requestAll() throws SQLException;

    public final T requestAllAndCompare() throws SQLException {
        List<T> results = this.requestAll();
        if (!results.stream().allMatch(result -> this.compare(results.get(0), result))) {
            throw new InconsistentDataException(results, this.endpoints);
        }
        return results.get(0);
    }

    private boolean compare(T data, T anotherData) {
        if (data instanceof byte[] && anotherData instanceof byte[]) {
            return Arrays.equals((byte[])data, (byte[])anotherData);
        }
        if (data instanceof short[] && anotherData instanceof short[]) {
            return Arrays.equals((short[])data, (short[])anotherData);
        }
        if (data instanceof int[] && anotherData instanceof int[]) {
            return Arrays.equals((int[])data, (int[])anotherData);
        }
        if (data instanceof long[] && anotherData instanceof long[]) {
            return Arrays.equals((long[])data, (long[])anotherData);
        }
        if (data instanceof char[] && anotherData instanceof char[]) {
            return Arrays.equals((char[])data, (char[])anotherData);
        }
        if (data instanceof float[] && anotherData instanceof float[]) {
            return Arrays.equals((float[])data, (float[])anotherData);
        }
        if (data instanceof double[] && anotherData instanceof double[]) {
            return Arrays.equals((double[])data, (double[])anotherData);
        }
        if (data instanceof boolean[] && anotherData instanceof boolean[]) {
            return Arrays.equals((boolean[])data, (boolean[])anotherData);
        }
        if (data instanceof Object[] && anotherData instanceof Object[]) {
            return Arrays.equals((Object[])data, (Object[])anotherData);
        }
        return Objects.equals(data, anotherData);
    }

    protected void handleExceptions(Exception[] exceptions) throws SQLException {
        int i;
        if (exceptions.length == 0) {
            return;
        }
        String[] exceptionMsg = new String[exceptions.length];
        Throwable[] businessExceptions = new Throwable[exceptions.length];
        boolean exceptionInconsistent = false;
        for (i = 0; i < exceptions.length; ++i) {
            if (exceptions[i] == null) continue;
            businessExceptions[i] = exceptions[i] instanceof ExecutionException ? exceptions[i].getCause() : exceptions[i];
            exceptionMsg[i] = businessExceptions[i].getMessage();
        }
        for (i = 1; i < exceptionMsg.length; ++i) {
            if (Objects.equals(exceptionMsg[i], exceptionMsg[0])) continue;
            exceptionInconsistent = true;
            break;
        }
        for (i = 0; i < businessExceptions.length; ++i) {
            if (businessExceptions[i] == null) continue;
            logger.warn("Exception happens during request to {}", (Object)this.getEndpoints().get(i), (Object)businessExceptions[i]);
        }
        if (!exceptionInconsistent && exceptionMsg[0] != null) {
            throw new SQLException(exceptionMsg[0]);
        }
        if (exceptionInconsistent) {
            throw new InconsistentDataException(Arrays.asList(exceptionMsg), this.getEndpoints());
        }
    }

    protected List<String> getEndpoints() {
        return this.endpoints;
    }

    protected List<Callable<T>> getRequests() {
        return this.requests;
    }
}

