/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.utils;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileGenerator
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileGenerator.class);
    private final File tsFile;
    private final TsFileWriter writer;
    private final Map<String, TreeSet<Long>> device2TimeSet;
    private final Map<String, List<IMeasurementSchema>> device2MeasurementSchema;
    private Random random;

    public TsFileGenerator(File tsFile) throws IOException {
        this.tsFile = tsFile;
        this.writer = new TsFileWriter(tsFile);
        this.device2TimeSet = new HashMap<String, TreeSet<Long>>();
        this.device2MeasurementSchema = new HashMap<String, List<IMeasurementSchema>>();
        this.random = new Random();
    }

    public void resetRandom() {
        this.random = new Random();
    }

    public void resetRandom(long seed) {
        this.random = new Random(seed);
    }

    public void registerTimeseries(String path, List<IMeasurementSchema> measurementSchemaList) {
        if (this.device2MeasurementSchema.containsKey(path)) {
            LOGGER.error("Register same device {}.", (Object)path);
            return;
        }
        this.writer.registerTimeseries(new Path(path), measurementSchemaList);
        this.device2TimeSet.put(path, new TreeSet());
        this.device2MeasurementSchema.put(path, measurementSchemaList);
    }

    public void registerAlignedTimeseries(String path, List<IMeasurementSchema> measurementSchemaList) throws WriteProcessException {
        if (this.device2MeasurementSchema.containsKey(path)) {
            LOGGER.error("Register same device {}.", (Object)path);
            return;
        }
        this.writer.registerAlignedTimeseries(new Path(path), measurementSchemaList);
        this.device2TimeSet.put(path, new TreeSet());
        this.device2MeasurementSchema.put(path, measurementSchemaList);
    }

    public void generateData(String device, int number, long timeGap, boolean isAligned) throws IOException, WriteProcessException {
        List<IMeasurementSchema> schemas = this.device2MeasurementSchema.get(device);
        TreeSet<Long> timeSet = this.device2TimeSet.get(device);
        Tablet tablet = new Tablet(device, schemas);
        long sensorNum = schemas.size();
        long startTime = timeSet.isEmpty() ? 0L : timeSet.last();
        for (long r = 0L; r < (long)number; ++r) {
            int row = tablet.getRowSize();
            tablet.addTimestamp(row, startTime += timeGap);
            timeSet.add(startTime);
            int i = 0;
            while ((long)i < sensorNum) {
                this.generateDataPoint(tablet, i, row, schemas.get(i));
                ++i;
            }
            if (tablet.getRowSize() != tablet.getMaxRowNumber()) continue;
            this.writer.writeTree(tablet);
            tablet.reset();
        }
        if (tablet.getRowSize() != 0) {
            this.writer.writeTree(tablet);
            tablet.reset();
        }
        LOGGER.info("Write {} points into device {}", (Object)number, (Object)device);
    }

    public void generateData(String device, int number, long timeGap, boolean isAligned, long startTimestamp) throws IOException, WriteProcessException {
        List<IMeasurementSchema> schemas = this.device2MeasurementSchema.get(device);
        TreeSet<Long> timeSet = this.device2TimeSet.get(device);
        Tablet tablet = new Tablet(device, schemas);
        long sensorNum = schemas.size();
        long startTime = startTimestamp;
        for (long r = 0L; r < (long)number; ++r) {
            int row = tablet.getRowSize();
            tablet.addTimestamp(row, startTime += timeGap);
            timeSet.add(startTime);
            int i = 0;
            while ((long)i < sensorNum) {
                this.generateDataPoint(tablet, i, row, schemas.get(i));
                ++i;
            }
            if (tablet.getRowSize() != tablet.getMaxRowNumber()) continue;
            this.writer.writeTree(tablet);
            tablet.reset();
        }
        if (tablet.getRowSize() != 0) {
            if (!isAligned) {
                this.writer.writeTree(tablet);
            } else {
                this.writer.writeAligned(tablet);
            }
            tablet.reset();
        }
        LOGGER.info("Write {} points into device {}", (Object)number, (Object)device);
    }

    private void generateDataPoint(Tablet tablet, int column, int row, IMeasurementSchema schema) {
        switch (schema.getType()) {
            case INT32: {
                this.generateINT32(tablet, column, row);
                break;
            }
            case DATE: {
                this.generateDATE(tablet, column, row);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.generateINT64(tablet, column, row);
                break;
            }
            case FLOAT: {
                this.generateFLOAT(tablet, column, row);
                break;
            }
            case DOUBLE: {
                this.generateDOUBLE(tablet, column, row);
                break;
            }
            case BOOLEAN: {
                this.generateBOOLEAN(tablet, column, row);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.generateTEXT(tablet, column, row);
                break;
            }
            default: {
                LOGGER.error("Wrong data type {}.", (Object)schema.getType());
            }
        }
    }

    private void generateINT32(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, this.random.nextInt());
    }

    private void generateDATE(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, LocalDate.of(1000 + this.random.nextInt(9000), 1 + this.random.nextInt(12), 1 + this.random.nextInt(28)));
    }

    private void generateINT64(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, this.random.nextLong());
    }

    private void generateFLOAT(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, this.random.nextFloat());
    }

    private void generateDOUBLE(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, this.random.nextDouble());
    }

    private void generateBOOLEAN(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, this.random.nextBoolean());
    }

    private void generateTEXT(Tablet tablet, int column, int row) {
        tablet.addValue(row, column, String.format("test point %d", this.random.nextInt()));
    }

    public void generateDeletion(String device, int number) throws IOException, IllegalPathException {
        try (ModificationFile modificationFile = new ModificationFile(ModificationFile.getExclusiveMods((File)this.tsFile), false);){
            this.writer.flush();
            TreeSet<Long> timeSet = this.device2TimeSet.get(device);
            if (timeSet.isEmpty()) {
                return;
            }
            long maxTime = timeSet.last() - 1L;
            for (int i = 0; i < number; ++i) {
                int endTime = this.random.nextInt((int)maxTime) + 1;
                int startTime = this.random.nextInt(endTime);
                for (IMeasurementSchema measurementSchema : this.device2MeasurementSchema.get(device)) {
                    TreeDeletionEntry deletion = new TreeDeletionEntry(new MeasurementPath(device, measurementSchema.getMeasurementName()), (long)startTime, (long)endTime);
                    modificationFile.write((ModEntry)deletion);
                }
                for (long j = (long)startTime; j <= (long)endTime; ++j) {
                    timeSet.remove(j);
                }
                LOGGER.info("Delete {} - {} timestamp of device {}", new Object[]{startTime, endTime, device});
            }
        }
    }

    public long getTotalNumber() {
        return this.device2TimeSet.entrySet().stream().mapToInt(entry -> ((TreeSet)entry.getValue()).size() * this.device2MeasurementSchema.get(entry.getKey()).size()).sum();
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

