/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.cluster;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.it.env.cluster.ClusterConstant;
import org.apache.iotdb.it.framework.IoTDBTestLogger;
import org.apache.tsfile.utils.Pair;

public class EnvUtils {
    public static int[] searchAvailablePorts() {
        int length = 10;
        while (true) {
            int randomPortStart = 1000 + (int)(Math.random() * 999.0);
            randomPortStart = randomPortStart * (length + 1) + 1;
            String lockFilePath = EnvUtils.getLockFilePath(randomPortStart);
            File lockFile = new File(lockFilePath);
            try {
                if (!lockFile.createNewFile()) continue;
                List<Integer> requiredPorts = IntStream.rangeClosed(randomPortStart, randomPortStart + length).boxed().collect(Collectors.toList());
                if (EnvUtils.checkPortsAvailable(requiredPorts)) {
                    return requiredPorts.stream().mapToInt(Integer::intValue).toArray();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!lockFile.exists() || lockFile.delete()) continue;
            IoTDBTestLogger.logger.error("Delete lockfile {} failed", (Object)lockFilePath);
        }
    }

    private static boolean checkPortsAvailable(List<Integer> ports) {
        String cmd = EnvUtils.getSearchAvailablePortCmd(ports);
        try {
            return Runtime.getRuntime().exec(cmd).waitFor() == 1;
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private static String getSearchAvailablePortCmd(List<Integer> ports) {
        return SystemUtils.IS_OS_WINDOWS ? EnvUtils.getWindowsSearchPortCmd(ports) : EnvUtils.getUnixSearchPortCmd(ports);
    }

    private static String getWindowsSearchPortCmd(List<Integer> ports) {
        return "netstat -aon -p tcp | findStr " + ports.stream().map(v -> "/C:'127.0.0.1:" + v + "'").collect(Collectors.joining(" "));
    }

    private static String getUnixSearchPortCmd(List<Integer> ports) {
        return "lsof -iTCP -sTCP:LISTEN -P -n | awk '{print $9}' | grep -E " + ports.stream().map(String::valueOf).collect(Collectors.joining("|")) + "\"";
    }

    private static Pair<Integer, Integer> getClusterNodesNum(int index) {
        String valueStr = System.getProperty("ClusterConfigurations");
        if (valueStr == null) {
            return null;
        }
        try {
            switch (EnvUtils.getValueOfIndex(valueStr, index)) {
                case "LightWeightStandaloneMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("lightWeightStandaloneMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("lightWeightStandaloneMode.dataNodeNumber")));
                }
                case "ScalableSingleNodeMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("scalableSingleNodeMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("scalableSingleNodeMode.dataNodeNumber")));
                }
                case "HighPerformanceMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("highPerformanceMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("highPerformanceMode.dataNodeNumber")));
                }
                case "StrongConsistencyClusterMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("strongConsistencyClusterMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("strongConsistencyClusterMode.dataNodeNumber")));
                }
                case "PipeConsensusBatchMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("pipeConsensusBatchMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("pipeConsensusBatchMode.dataNodeNumber")));
                }
                case "PipeConsensusStreamMode": {
                    return new Pair((Object)Integer.parseInt(System.getProperty("pipeConsensusStreamMode.configNodeNumber")), (Object)Integer.parseInt(System.getProperty("pipeConsensusStreamMode.dataNodeNumber")));
                }
            }
            return null;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    public static String getLockFilePath(int port) {
        return ClusterConstant.LOCK_FILE_PATH + port;
    }

    public static Pair<Integer, Integer> getNodeNum() {
        Pair<Integer, Integer> nodesNum = EnvUtils.getClusterNodesNum(0);
        if (nodesNum != null) {
            return nodesNum;
        }
        return new Pair((Object)EnvUtils.getIntFromSysVar("DefaultConfigNodeNum", 1, 0), (Object)EnvUtils.getIntFromSysVar("DefaultDataNodeNum", 3, 0));
    }

    public static Pair<Integer, Integer> getNodeNum(int index) {
        Pair<Integer, Integer> nodesNum = EnvUtils.getClusterNodesNum(index);
        if (nodesNum != null) {
            return nodesNum;
        }
        return new Pair((Object)EnvUtils.getIntFromSysVar("DefaultConfigNodeNum", 1, index), (Object)EnvUtils.getIntFromSysVar("DefaultDataNodeNum", 3, index));
    }

    public static String getFilePathFromSysVar(String key, int index) {
        String valueStr = System.getProperty(key);
        if (valueStr == null) {
            return null;
        }
        return System.getProperty("user.dir") + EnvUtils.getValueOfIndex(valueStr, index);
    }

    public static int getIntFromSysVar(String key, int defaultValue, int index) {
        String valueStr = System.getProperty(key);
        if (valueStr == null) {
            return defaultValue;
        }
        String value = EnvUtils.getValueOfIndex(valueStr, index);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property value: " + value + " of key " + key);
        }
    }

    public static String getValueOfIndex(String valueStr, int index) {
        String[] values = valueStr.split(",");
        return index <= values.length - 1 ? values[index] : values[values.length - 1];
    }

    public static String getTimeForLogDirectory(long startTime) {
        return DateTimeUtils.convertLongToDate((long)startTime, (String)"ms").replace(":", ".");
    }

    public static String fromConsensusFullNameToAbbr(String consensus) {
        switch (consensus) {
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": {
                return "Simple";
            }
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                return "Ratis";
            }
            case "org.apache.iotdb.consensus.iot.IoTConsensus": {
                return "IoT";
            }
            case "org.apache.iotdb.consensus.iot.IoTConsensusV2": {
                return "IoTV2";
            }
        }
        throw new IllegalArgumentException("Unknown consensus type: " + consensus);
    }

    public static String fromConsensusAbbrToFullName(String consensus) {
        switch (consensus) {
            case "Simple": {
                return "org.apache.iotdb.consensus.simple.SimpleConsensus";
            }
            case "Ratis": {
                return "org.apache.iotdb.consensus.ratis.RatisConsensus";
            }
            case "IoT": {
                return "org.apache.iotdb.consensus.iot.IoTConsensus";
            }
            case "IoTV2": {
                return "org.apache.iotdb.consensus.iot.IoTConsensusV2";
            }
        }
        throw new IllegalArgumentException("Unknown consensus type: " + consensus);
    }

    private EnvUtils() {
        throw new IllegalStateException("Utility class");
    }
}

