/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.example;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerFireTimesCounter
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerFireTimesCounter.class);
    private String TXT_PATH;
    private final int LOCK_FILE_RETRY_TIME = 10;

    public void onCreate(TriggerAttributes attributes) throws Exception {
        String counterName = attributes.getString("name");
        this.TXT_PATH = System.getProperty("user.dir") + File.separator + "target" + File.separator + "test-classes" + File.separator + counterName + ".txt";
        Path path = Paths.get(this.TXT_PATH, new String[0]);
        Files.deleteIfExists(path);
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        Files.write(Paths.get(this.TXT_PATH, new String[0]), String.valueOf(0).getBytes(), new OpenOption[0]);
    }

    public void onDrop() throws Exception {
        Files.deleteIfExists(Paths.get(this.TXT_PATH, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire(Tablet tablet) throws Exception {
        FileLock fileLock = null;
        AbstractInterruptibleChannel fileChannel = null;
        int retryNum = 0;
        try {
            fileChannel = FileChannel.open(Paths.get(this.TXT_PATH, new String[0]), StandardOpenOption.APPEND);
            while (fileLock == null) {
                fileLock = ((FileChannel)fileChannel).tryLock();
                if (fileLock != null) continue;
                if (retryNum++ >= 10) break;
                Thread.sleep(100L);
            }
            int rows = tablet.getRowSize();
            if (fileLock != null && fileLock.isValid()) {
                String records = System.lineSeparator() + rows;
                ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                byteBuffer.put(records.getBytes());
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    ((FileChannel)fileChannel).write(byteBuffer);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("TriggerFireTimesCounter error", t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        return true;
    }
}

