/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.example.relational;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;

public class MyCount
implements AggregateFunction {
    public AggregateFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() == 0) {
            throw new UDFArgumentNotValidException("MyCount accepts at least one parameter");
        }
        return new AggregateFunctionAnalysis.Builder().outputDataType(Type.INT64).build();
    }

    public State createState() {
        return new CountState();
    }

    public void addInput(State state, Record input) {
        CountState countState = (CountState)state;
        for (int i = 0; i < input.size(); ++i) {
            if (input.isNull(i)) continue;
            ++countState.count;
            break;
        }
    }

    public void combineState(State state, State rhs) {
        ((CountState)state).count += ((CountState)rhs).count;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        resultValue.setLong(((CountState)state).count);
    }

    static class CountState
    implements State {
        long count;

        CountState() {
        }

        public void reset() {
            this.count = 0L;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(this.count);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.count = buffer.getLong();
        }
    }
}

