/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.it.env.remote.env;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncConfigNodeIServiceClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.SessionConfig;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.it.env.EnvFactory;
import org.apache.iotdb.it.env.cluster.node.AbstractNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.ConfigNodeWrapper;
import org.apache.iotdb.it.env.cluster.node.DataNodeWrapper;
import org.apache.iotdb.it.env.remote.config.RemoteClusterConfig;
import org.apache.iotdb.itbase.env.BaseEnv;
import org.apache.iotdb.itbase.env.BaseNodeWrapper;
import org.apache.iotdb.itbase.env.ClusterConfig;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.pool.SessionPool;

public class RemoteServerEnv
implements BaseEnv {
    private final String ip_addr = System.getProperty("RemoteIp", "127.0.0.1");
    private final String port = System.getProperty("RemotePort", "6667");
    private final String configNodeMetricPort = System.getProperty("RemoteConfigNodeMetricPort", "9091");
    private final String dataNodeMetricPort = System.getProperty("RemoteDataNodeMetricPort", "9093");
    private final String user = System.getProperty("RemoteUser", "root");
    private final String password = System.getProperty("RemotePassword", "root");
    private IClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager;
    private RemoteClusterConfig clusterConfig = new RemoteClusterConfig();

    @Override
    public void initClusterEnvironment() {
        try (Connection connection = EnvFactory.getEnv().getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE DATABASE root.init;");
            statement.execute("DELETE DATABASE root.init;");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncConfigNodeIServiceClientPoolFactory());
    }

    @Override
    public void initClusterEnvironment(int configNodesNum, int dataNodesNum) {
        this.initClusterEnvironment();
    }

    @Override
    public void initClusterEnvironment(int configNodesNum, int dataNodesNum, int testWorkingRetryCount) {
        this.initClusterEnvironment();
    }

    @Override
    public void cleanClusterEnvironment() {
        if (this.clientManager != null) {
            this.clientManager.close();
        }
        this.clusterConfig = new RemoteClusterConfig();
    }

    @Override
    public ClusterConfig getConfig() {
        return this.clusterConfig;
    }

    @Override
    public List<String> getMetricPrometheusReporterContents(String authHeader) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getUrlContent("http://" + this.ip_addr + ":" + this.configNodeMetricPort + "/metrics", authHeader));
        result.add(this.getUrlContent("http://" + this.ip_addr + ":" + this.dataNodeMetricPort + "/metrics", authHeader));
        return result;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection;
        try {
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            connection = DriverManager.getConnection("jdbc:iotdb://" + this.ip_addr + ":" + this.port, this.user, this.password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new AssertionError();
        }
        return connection;
    }

    @Override
    public Connection getWriteOnlyConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode, String username, String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnectionWithSpecifiedDataNode(DataNodeWrapper dataNode, String username, String password) throws SQLException {
        return this.getConnection(username, password);
    }

    @Override
    public Connection getConnection(Constant.Version version, String username, String password) throws SQLException {
        Connection connection;
        try {
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            connection = DriverManager.getConnection("jdbc:iotdb://" + this.ip_addr + ":" + this.port + "?" + "version" + "=" + version.toString(), this.user, this.password);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new AssertionError();
        }
        return connection;
    }

    @Override
    public Connection getConnection(DataNodeWrapper dataNodeWrapper, String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTestMethodName(String testCaseName) {
    }

    @Override
    public void dumpTestJVMSnapshot() {
    }

    @Override
    public List<AbstractNodeWrapper> getNodeWrapperList() {
        return null;
    }

    @Override
    public List<ConfigNodeWrapper> getConfigNodeWrapperList() {
        return null;
    }

    @Override
    public List<DataNodeWrapper> getDataNodeWrapperList() {
        return null;
    }

    @Override
    public IConfigNodeRPCService.Iface getLeaderConfigNodeConnection() throws ClientManagerException {
        return (IConfigNodeRPCService.Iface)this.clientManager.borrowClient((Object)new TEndPoint(this.ip_addr, 10710));
    }

    @Override
    public ISessionPool getSessionPool(int maxSize) {
        return new SessionPool("localhost", 6667, "root", "root", maxSize, 5000, 60000L, false, null, true, 0, SessionConfig.DEFAULT_VERSION, 1024, 0x4000000);
    }

    @Override
    public ISession getSessionConnection() throws IoTDBConnectionException {
        Session session = new Session(this.ip_addr, Integer.parseInt(this.port));
        session.open();
        return session;
    }

    @Override
    public ISession getSessionConnection(ZoneId zoneId) throws IoTDBConnectionException {
        Session session = new Session(this.ip_addr, Integer.parseInt(this.port), "root", "root", zoneId);
        session.open();
        return session;
    }

    @Override
    public ISession getSessionConnection(String userName, String password) throws IoTDBConnectionException {
        Session session = new Session(this.ip_addr, Integer.parseInt(this.port), userName, password);
        session.open();
        return session;
    }

    @Override
    public ISession getSessionConnection(List<String> nodeUrls) throws IoTDBConnectionException {
        Session session = new Session(Collections.singletonList(this.ip_addr + ":" + this.port), "root", "root", 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
        session.open();
        return session;
    }

    @Override
    public int getFirstLeaderSchemaRegionDataNodeIndex() {
        return -1;
    }

    @Override
    public int getLeaderConfigNodeIndex() {
        return -1;
    }

    @Override
    public void startConfigNode(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startAllConfigNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownConfigNode(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownAllConfigNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownForciblyAllConfigNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureNodeStatus(List<BaseNodeWrapper> nodes, List<NodeStatus> targetStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigNodeWrapper generateRandomConfigNodeWrapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataNodeWrapper generateRandomDataNodeWrapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigNodeWrapper getConfigNodeWrapper(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataNodeWrapper getDataNodeWrapper(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerNewDataNode(boolean isNeedVerify) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerNewConfigNode(boolean isNeedVerify) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerNewDataNode(DataNodeWrapper newDataNodeWrapper, boolean isNeedVerify) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerNewConfigNode(ConfigNodeWrapper newConfigNodeWrapper, boolean isNeedVerify) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startDataNode(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startAllDataNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownDataNode(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownAllDataNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownForciblyAllDataNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMqttPort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIP() {
        return this.ip_addr;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getSbinPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getToolsPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLibPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<DataNodeWrapper> dataNodeIdToWrapper(int nodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConfigNodeKillPoints(List<String> killPoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerDataNodeKillPoints(List<String> killPoints) {
        throw new UnsupportedOperationException();
    }
}

