/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.itbase.runtime;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iotdb.it.env.EnvFactory;
import org.apache.iotdb.itbase.exception.ParallelRequestTimeoutException;
import org.apache.iotdb.itbase.runtime.RequestDelegate;
import org.apache.iotdb.itbase.runtime.RequestThreadPool;

public class ParallelRequestDelegate<T>
extends RequestDelegate<T> {
    private final int taskTimeoutSeconds;

    public ParallelRequestDelegate(List<String> endpoints, int taskTimeoutSeconds) {
        super(endpoints);
        this.taskTimeoutSeconds = taskTimeoutSeconds;
    }

    @Override
    public List<T> requestAll() throws SQLException {
        ArrayList resultFutures = new ArrayList(this.getRequests().size());
        for (Callable request : this.getRequests()) {
            Future f = RequestThreadPool.submit(request);
            resultFutures.add(f);
        }
        ArrayList results = new ArrayList(this.getRequests().size());
        Exception[] exceptions = new Exception[this.getEndpoints().size()];
        for (int i = 0; i < this.getEndpoints().size(); ++i) {
            try {
                results.add(((Future)resultFutures.get(i)).get(this.taskTimeoutSeconds, TimeUnit.SECONDS));
                continue;
            }
            catch (ExecutionException e) {
                exceptions[i] = e;
                continue;
            }
            catch (InterruptedException | TimeoutException e) {
                EnvFactory.getEnv().dumpTestJVMSnapshot();
                for (int j = i; j < this.getEndpoints().size(); ++j) {
                    ((Future)resultFutures.get(j)).cancel(true);
                }
                throw new ParallelRequestTimeoutException(String.format("Waiting for query results of %s timeout", this.getEndpoints().get(i)), e);
            }
        }
        this.handleExceptions(exceptions);
        return results;
    }
}

