/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mqtt.server;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.protocol.mqtt.Message;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.protocol.mqtt.TreeMessage;

public class CustomizedJsonPayloadFormatter
implements PayloadFormatter {
    public List<Message> format(ByteBuf payload) {
        if (payload == null) {
            return Collections.emptyList();
        }
        ArrayList<Message> ret = new ArrayList<Message>();
        for (int i = 0; i < 2; ++i) {
            long ts = i;
            TreeMessage message = new TreeMessage();
            message.setDevice("d" + i);
            message.setTimestamp(Long.valueOf(ts));
            message.setMeasurements(Arrays.asList("s1", "s2"));
            message.setValues(Arrays.asList("4.0" + i, "5.0" + i));
            ret.add((Message)message);
        }
        return ret;
    }

    public String getName() {
        return "CustomizedJson";
    }

    public String getType() {
        return "tree";
    }
}

