/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.session.Session;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TabletExample {
    private static final String TIME_STR = "time";

    private static Map<String, ArrayList<Object>> loadCSVData(Map<String, TSDataType> measureTSTypeInfos, String dataFileName) throws IOException {
        measureTSTypeInfos.put(TIME_STR, TSDataType.INT64);
        try {
            HashMap<String, ArrayList<Object>> hashMap;
            try (BufferedReader reader = new BufferedReader(new FileReader(dataFileName));){
                String line;
                String headline = reader.readLine();
                if (headline == null) {
                    throw new IOException("Given csv data file has not headers");
                }
                String[] fileColumns = headline.split(",");
                HashMap<Object, Integer> columnToIdMap = new HashMap<Object, Integer>();
                for (int col = 0; col < fileColumns.length; ++col) {
                    String columnName = fileColumns[col];
                    if (columnToIdMap.containsKey(columnName)) {
                        throw new IOException(String.format("csv file contains duplicate columns: %s", columnName));
                    }
                    columnToIdMap.put(columnName, col);
                }
                HashMap<String, ArrayList<Object>> ret = new HashMap<String, ArrayList<Object>>();
                for (Map.Entry hashMap2 : measureTSTypeInfos.entrySet()) {
                    String measurement = (String)hashMap2.getKey();
                    if (!columnToIdMap.containsKey(hashMap2.getKey())) {
                        throw new IOException(String.format("measurement %s's is not in csv file.", measurement));
                    }
                    ret.put(measurement, new ArrayList());
                }
                while ((line = reader.readLine()) != null) {
                    String[] stringArray = line.split(",");
                    block20: for (Map.Entry<String, TSDataType> entry : measureTSTypeInfos.entrySet()) {
                        String measurement = entry.getKey();
                        TSDataType dataType = entry.getValue();
                        int idx = (Integer)columnToIdMap.get(measurement);
                        switch (dataType) {
                            case BOOLEAN: {
                                ((ArrayList)ret.get(measurement)).add(Boolean.parseBoolean(stringArray[idx]));
                                continue block20;
                            }
                            case DATE: 
                            case INT32: {
                                ((ArrayList)ret.get(measurement)).add(Integer.parseInt(stringArray[idx]));
                                continue block20;
                            }
                            case TIMESTAMP: 
                            case INT64: {
                                ((ArrayList)ret.get(measurement)).add(Long.parseLong(stringArray[idx]));
                                continue block20;
                            }
                            case FLOAT: {
                                ((ArrayList)ret.get(measurement)).add(Float.valueOf(Float.parseFloat(stringArray[idx])));
                                continue block20;
                            }
                            case DOUBLE: {
                                ((ArrayList)ret.get(measurement)).add(Double.parseDouble(stringArray[idx]));
                                continue block20;
                            }
                            case STRING: 
                            case BLOB: 
                            case TEXT: {
                                ((ArrayList)ret.get(measurement)).add(BytesUtils.valueOf((String)stringArray[idx]));
                                continue block20;
                            }
                            case VECTOR: {
                                throw new IOException(String.format("data type %s is not yet.", TSDataType.VECTOR));
                            }
                        }
                        throw new IOException("no type");
                    }
                }
                hashMap = ret;
            }
            return hashMap;
        }
        finally {
            measureTSTypeInfos.remove(TIME_STR);
        }
    }

    public static void main(String[] args) throws Exception {
        try (Session session = new Session("127.0.0.1", 6667, "root", "root");){
            session.open();
            String dataFileName = "sample.csv";
            int rowSize = 10000;
            int colSize = 5000;
            if (args.length > 1) {
                dataFileName = args[0];
            }
            if (args.length > 2) {
                rowSize = Integer.parseInt(args[1]);
            }
            if (args.length > 3) {
                colSize = Integer.parseInt(args[2]);
            }
            HashMap<String, TSDataType> measureTSTypeInfos = new HashMap<String, TSDataType>();
            measureTSTypeInfos.put("s0", TSDataType.BOOLEAN);
            measureTSTypeInfos.put("s1", TSDataType.FLOAT);
            measureTSTypeInfos.put("s2", TSDataType.INT32);
            measureTSTypeInfos.put("s3", TSDataType.DOUBLE);
            measureTSTypeInfos.put("s4", TSDataType.INT64);
            measureTSTypeInfos.put("s5", TSDataType.TEXT);
            ArrayList schemas = new ArrayList();
            measureTSTypeInfos.forEach((mea, type) -> schemas.add(new MeasurementSchema(mea, type)));
            System.out.println(String.format("Test Java: csv file name: %s, row: %d, col: %d", dataFileName, rowSize, colSize));
            System.out.println(String.format("Total points: %d", rowSize * colSize * schemas.size()));
            long allStart = System.nanoTime();
            Map<String, ArrayList<Object>> data = TabletExample.loadCSVData(measureTSTypeInfos, dataFileName);
            long loadCost = System.nanoTime() - allStart;
            long insertCost = 0L;
            for (int i = 0; i < colSize; ++i) {
                String deviceId = "root.sg" + i % 8 + "." + i;
                Tablet ta = new Tablet(deviceId, schemas, rowSize);
                ta.rowSize = rowSize;
                for (int t = 0; t < ta.rowSize; ++t) {
                    ta.addTimestamp(t, ((Long)data.get(TIME_STR).get(t)).longValue());
                    for (Map.Entry entry : measureTSTypeInfos.entrySet()) {
                        String mea2 = (String)entry.getKey();
                        ta.addValue(mea2, t, data.get(mea2).get(t));
                    }
                }
                long insertSt = System.nanoTime();
                session.insertTablet(ta, false);
                insertCost += System.nanoTime() - insertSt;
            }
            long allEnd = System.nanoTime();
            session.executeNonQueryStatement("delete timeseries root.*");
            System.out.println(String.format("load cost: %.3f", Float.valueOf((float)loadCost / 1.0E9f)));
            System.out.println(String.format("construct tablet cost: %.3f", Float.valueOf((float)(allEnd - allStart - insertCost - loadCost) / 1.0E9f)));
            System.out.println(String.format("insert tablet cost: %.3f", Float.valueOf((float)insertCost / 1.0E9f)));
            System.out.println(String.format("total cost: %.3f", Float.valueOf((float)(allEnd - allStart) / 1.0E9f)));
            System.out.println(String.format("%.3f", Float.valueOf((float)loadCost / 1.0E9f)));
        }
    }
}

