/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMigrationExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataMigrationExample.class);
    private static SessionPool readerPool;
    private static SessionPool writerPool;
    private static final int CONCURRENCY = 5;

    public static void main(String[] args) throws IoTDBConnectionException, StatementExecutionException, ExecutionException, InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        String path = "root.**";
        if (args.length != 0) {
            path = args[0];
        }
        readerPool = new SessionPool("127.0.0.1", 6667, "root", "root", 5);
        writerPool = new SessionPool("127.0.0.1", 6668, "root", "root", 5);
        SessionDataSetWrapper deviceDataSet = readerPool.executeQueryStatement("count devices " + path);
        SessionDataSet.DataIterator deviceIter = deviceDataSet.iterator();
        if (deviceIter.next()) {
            int total = deviceIter.getInt(1);
            LOGGER.info("Total devices: {}", (Object)total);
        } else {
            LOGGER.error("Can not get devices schema");
            System.exit(1);
        }
        readerPool.closeResultSet(deviceDataSet);
        deviceDataSet = readerPool.executeQueryStatement("show devices " + path);
        deviceIter = deviceDataSet.iterator();
        ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>();
        int count = 0;
        while (deviceIter.next()) {
            Future<Void> future = executorService.submit(new LoadThread(++count, deviceIter.getString("Device")));
            futureList.add(future);
        }
        readerPool.closeResultSet(deviceDataSet);
        for (Future future : futureList) {
            future.get();
        }
        executorService.shutdown();
        readerPool.close();
        writerPool.close();
    }

    static class LoadThread
    implements Callable<Void> {
        String device;
        Tablet tablet;
        int i;

        public LoadThread(int i, String device) {
            this.i = i;
            this.device = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() {
            SessionDataSetWrapper dataSet = null;
            long startTime = System.currentTimeMillis();
            try {
                dataSet = readerPool.executeQueryStatement(String.format("select * from %s", this.device));
                SessionDataSet.DataIterator dataIter = dataSet.iterator();
                List columnNameList = dataIter.getColumnNameList();
                List columnTypeList = dataIter.getColumnTypeList();
                ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
                for (int j = 1; j < columnNameList.size(); ++j) {
                    PartialPath currentPath = new PartialPath((String)columnNameList.get(j));
                    schemaList.add(new MeasurementSchema(currentPath.getMeasurement(), TSDataType.valueOf((String)((String)columnTypeList.get(j)))));
                }
                this.tablet = new Tablet(this.device, schemaList, 300000);
                while (true) {
                    if (dataIter.next()) {
                        ++this.tablet.rowSize;
                        this.tablet.timestamps[row] = dataIter.getLong(1);
                    } else {
                        if (this.tablet.rowSize != 0) {
                            writerPool.insertTablet(this.tablet);
                            this.tablet.reset();
                        }
                        if (dataSet != null) {
                            readerPool.closeResultSet(dataSet);
                        }
                        long endTime = System.currentTimeMillis();
                        long totalTime = endTime - startTime;
                        LOGGER.info("migrate device \uff1a{}  using {}  ms", (Object)this.device, (Object)totalTime);
                        LOGGER.info("Loading the {}-th device: {}  success", (Object)this.i, (Object)this.device);
                        return null;
                    }
                    block15: for (int j = 0; j < schemaList.size(); ++j) {
                        int row;
                        if (dataIter.isNull(j + 2)) {
                            this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, null);
                            continue;
                        }
                        switch (((MeasurementSchema)schemaList.get(j)).getType()) {
                            case BOOLEAN: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)dataIter.getBoolean(j + 2));
                                continue block15;
                            }
                            case INT32: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)dataIter.getInt(j + 2));
                                continue block15;
                            }
                            case INT64: 
                            case TIMESTAMP: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)dataIter.getLong(j + 2));
                                continue block15;
                            }
                            case FLOAT: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)Float.valueOf(dataIter.getFloat(j + 2)));
                                continue block15;
                            }
                            case DOUBLE: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)dataIter.getDouble(j + 2));
                                continue block15;
                            }
                            case TEXT: 
                            case STRING: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, (Object)dataIter.getString(j + 2));
                                continue block15;
                            }
                            case DATE: 
                            case BLOB: {
                                this.tablet.addValue(((MeasurementSchema)schemaList.get(j)).getMeasurementId(), row, dataIter.getObject(j + 2));
                                continue block15;
                            }
                            default: {
                                LOGGER.info("Migration of this type of data is not supported");
                            }
                        }
                    }
                    if (this.tablet.rowSize != this.tablet.getMaxRowNumber()) continue;
                    writerPool.insertTablet(this.tablet, true);
                    this.tablet.reset();
                }
            }
            catch (Exception e) {
                Void void_;
                block22: {
                    try {
                        LOGGER.error("Loading the {}-th device: {} failed {}", new Object[]{this.i, this.device, e.getMessage()});
                        void_ = null;
                        if (dataSet == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (dataSet != null) {
                            readerPool.closeResultSet(dataSet);
                        }
                        long endTime = System.currentTimeMillis();
                        long totalTime = endTime - startTime;
                        LOGGER.info("migrate device \uff1a{}  using {}  ms", (Object)this.device, (Object)totalTime);
                        throw throwable;
                    }
                    readerPool.closeResultSet(dataSet);
                }
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                LOGGER.info("migrate device \uff1a{}  using {}  ms", (Object)this.device, (Object)totalTime);
                return void_;
            }
        }
    }
}

