/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_replace"}, parameter="(String source_string, String regexp, String replacement)", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return a string from 'source_string' with all the substrings that match a regular expression 'regexp' consecutively being replaced with 'replacement'."}, examples={"regexp_replace('foobarbaz', 'b..', 'X') = \"fooXbaz\""})
public class RegexpReplaceFunction
implements ValueParser {
    private ValueParser inputStringParser;
    private ValueParser patternStringParser;
    private ValueParser replaceStringParser;

    public RegexpReplaceFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() >= 3) {
            this.inputStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternStringParser = OperatorTools.buildParser((Expression)expressions.get(1));
            this.replaceStringParser = OperatorTools.buildParser((Expression)expressions.get(2));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputStringParser == null || this.patternStringParser == null || this.replaceStringParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputStringParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternStringParser.parse(sourceData, rowIndex, context));
        String replaceString = OperatorTools.parseString(this.replaceStringParser.parse(sourceData, rowIndex, context));
        Pattern pattern = Pattern.compile(patternString);
        return pattern.matcher(inputString).replaceAll(replaceString);
    }
}

