/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"cotd"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if numeric is NULL;", "- Return the cotangent of numeric in units of degrees."}, examples={"cotd(0) = \"\"", "cotd(45) = 1.0000000000000002", "cotd(-1) = -57.28996163075943"})
public class CotdFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(CotdFunction.class);
    private ValueParser numberParser;

    public CotdFunction(Function expr) {
        this.numberParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.numberParser.parse(sourceData, rowIndex, context);
        if (valueObj == null) {
            return null;
        }
        BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
        double tanValue = Math.tan(Math.toRadians(value.doubleValue()));
        if (tanValue == 0.0) {
            throw new ArithmeticException("Cotangent undefined for this input, tan(x) is zero.");
        }
        return 1.0 / tanValue;
    }
}

