/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.AbstractSourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSourceData
extends AbstractSourceData {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetSourceData.class);
    public static final String ROOT_KEY = "$root.";
    public static final String CHILD_KEY = "$child.";
    private Group rootGroup;
    private Group childParent;
    private String childName;
    private Charset srcCharset;
    private Type childType;
    private int rowCount = -1;

    public ParquetSourceData(Group root, String childPath, Charset srcCharset, Context context) {
        this.rootGroup = root;
        String pathStr = "";
        if (!StringUtils.isEmpty((CharSequence)childPath)) {
            pathStr = childPath;
        }
        if (!StringUtils.isEmpty((CharSequence)pathStr)) {
            String[] pathNodes = pathStr.split("\\.");
            this.childName = pathNodes[pathNodes.length - 1];
            this.childParent = this.parsePath(this.rootGroup, pathNodes);
            if (this.childParent != null) {
                this.childType = this.childParent.getType().getType(this.childName);
                this.rowCount = this.childParent.getFieldRepetitionCount(this.childName);
            }
        }
        this.srcCharset = srcCharset;
        this.context = context;
    }

    @Override
    public int getRowCount() {
        if (this.childParent == null) {
            return 1;
        }
        return this.rowCount;
    }

    @Override
    public String getField(int rowNum, String fieldName) {
        String fieldValue = "";
        try {
            if (this.isContextField(fieldName)) {
                return this.getContextField(fieldName);
            }
            if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)ROOT_KEY)) {
                fieldName = fieldName.substring(ROOT_KEY.length());
                fieldValue = this.parseFields(fieldName, this.rootGroup);
            } else if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)CHILD_KEY)) {
                if (this.childType instanceof GroupType) {
                    if (this.childParent != null && rowNum < this.getRowCount()) {
                        Group group = this.childParent.getGroup(this.childName, rowNum);
                        fieldName = fieldName.substring(CHILD_KEY.length());
                        fieldValue = this.parseFields(fieldName, group);
                    }
                } else {
                    fieldValue = this.getFieldValue(this.childParent, this.childName).toString();
                }
            }
            return fieldValue;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return fieldValue;
        }
    }

    private String parseFields(String fieldName, Group rootGroup) {
        String[] pathNodes = fieldName.split("\\.");
        Group parNode = this.parsePath(rootGroup, pathNodes);
        return this.getFieldValue(parNode, pathNodes[pathNodes.length - 1]).toString();
    }

    public Group parsePath(Group root, String[] path) {
        Object cur = root;
        Group last = null;
        int lastIdx = path.length - 1;
        for (int i = 0; i <= lastIdx; ++i) {
            if (!(cur instanceof Group)) {
                if (i == lastIdx) {
                    return last;
                }
                return null;
            }
            Object value = this.getFieldValue((Group)cur, path[i]);
            last = cur;
            cur = value;
            if (cur != null) continue;
            return null;
        }
        return last;
    }

    public Object getFieldValue(Group group, String fieldName) {
        try {
            Type field;
            int idx = 0;
            int start = fieldName.indexOf(40);
            if (start != -1) {
                idx = Integer.parseInt(fieldName.substring(start + 1, fieldName.indexOf(41)));
                fieldName = fieldName.substring(0, start);
            }
            if ((field = group.getType().getType(fieldName)).isPrimitive()) {
                switch (field.asPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return group.getInteger(fieldName, idx);
                    }
                    case INT64: {
                        return group.getLong(fieldName, idx);
                    }
                    case INT96: {
                        return group.getInt96(fieldName, idx);
                    }
                    case FLOAT: {
                        return Float.valueOf(group.getFloat(fieldName, idx));
                    }
                    case DOUBLE: {
                        return group.getDouble(fieldName, idx);
                    }
                    case BOOLEAN: {
                        return group.getBoolean(fieldName, idx);
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        return group.getBinary(fieldName, idx).getBytes();
                    }
                    case BINARY: {
                        return new String(group.getBinary(fieldName, idx).getBytes(), this.srcCharset);
                    }
                }
                LOG.error("Unsupported type for field: {} ,field name: {}", (Object)field, (Object)fieldName);
                return null;
            }
            return group.getGroup(fieldName, idx);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

