/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.DataNodeApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodePageRequest;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;

public class DataNodeClient {
    private final DataNodeApi dataNodeApi;

    public DataNodeClient(ClientConfiguration configuration) {
        this.dataNodeApi = (DataNodeApi)ClientUtils.createRetrofit(configuration).create(DataNodeApi.class);
    }

    public Integer save(DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be empty");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be empty");
        Response<Integer> response = ClientUtils.executeHttpCall(this.dataNodeApi.save(request));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public DataNodeInfo get(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"data node id cannot be null");
        Response<DataNodeInfo> response = ClientUtils.executeHttpCall(this.dataNodeApi.get(id));
        ClientUtils.assertRespSuccess(response);
        return (DataNodeInfo)response.getData();
    }

    public PageResult<DataNodeInfo> list(DataNodePageRequest pageRequest) {
        Preconditions.expectNotNull((Object)pageRequest, (String)"request cannot be null");
        Response<PageResult<DataNodeInfo>> response = ClientUtils.executeHttpCall(this.dataNodeApi.list(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public Boolean update(DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be empty");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be empty");
        Preconditions.expectNotNull((Object)request.getId(), (String)"data node id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.dataNodeApi.update(request));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public UpdateResult updateByKey(DataNodeRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"request cannot be null");
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be empty");
        Preconditions.expectNotBlank((String)request.getType(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be empty");
        Response<UpdateResult> response = ClientUtils.executeHttpCall(this.dataNodeApi.updateByKey(request));
        ClientUtils.assertRespSuccess(response);
        return (UpdateResult)response.getData();
    }

    public Boolean delete(Integer id) {
        Preconditions.expectNotNull((Object)id, (String)"data node id cannot be null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.dataNodeApi.delete(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public Boolean deleteByKey(String name, String type) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node name cannot be empty or null");
        Preconditions.expectNotBlank((String)type, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"data node type cannot be empty or null");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.dataNodeApi.deleteByKey(name, type));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

