/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.StreamSinkApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.sink.ParseFieldRequest;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkPageRequest;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;

public class StreamSinkClient {
    private final StreamSinkApi streamSinkApi;

    public StreamSinkClient(ClientConfiguration configuration) {
        this.streamSinkApi = (StreamSinkApi)ClientUtils.createRetrofit(configuration).create(StreamSinkApi.class);
    }

    public Integer createSink(SinkRequest sinkRequest) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.streamSinkApi.save(sinkRequest));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public List<BatchResult> batchCreateSink(List<SinkRequest> sinkRequests) {
        Response<List<BatchResult>> response = ClientUtils.executeHttpCall(this.streamSinkApi.batchSave(sinkRequests));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public boolean deleteSink(int id) {
        Preconditions.expectTrue((id > 0 ? 1 : 0) != 0, (String)"sinkId is illegal");
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSinkApi.deleteById(id));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public boolean deleteSinkByKey(String groupId, String streamId, String name) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSinkApi.deleteByKey(groupId, streamId, name));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }

    public List<StreamSink> listSinks(String groupId, String streamId) {
        return this.listSinks(groupId, streamId, null);
    }

    public List<StreamSink> listSinks(String groupId, String streamId, String sinkType) {
        SinkPageRequest pageRequest = new SinkPageRequest();
        pageRequest.setInlongGroupId(groupId);
        pageRequest.setInlongStreamId(streamId);
        pageRequest.setSinkType(sinkType);
        Response<PageResult<StreamSink>> response = ClientUtils.executeHttpCall(this.streamSinkApi.list(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public List<StreamSink> listSinks(SinkPageRequest pageRequest) {
        Response<PageResult<StreamSink>> response = ClientUtils.executeHttpCall(this.streamSinkApi.list(pageRequest));
        ClientUtils.assertRespSuccess(response);
        return ((PageResult)response.getData()).getList();
    }

    public Pair<Boolean, String> updateSink(SinkRequest sinkRequest) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamSinkApi.updateById(sinkRequest));
        ClientUtils.assertRespSuccess(response);
        if (response.getData() != null) {
            return Pair.of((Object)response.getData(), (Object)response.getErrMsg());
        }
        return Pair.of((Object)false, (Object)response.getErrMsg());
    }

    public Pair<UpdateResult, String> updateSinkByKey(SinkRequest sinkRequest) {
        Response<UpdateResult> response = ClientUtils.executeHttpCall(this.streamSinkApi.updateByKey(sinkRequest));
        ClientUtils.assertRespSuccess(response);
        if (response.getData() != null) {
            return Pair.of((Object)response.getData(), (Object)response.getErrMsg());
        }
        return Pair.of((Object)new UpdateResult(), (Object)response.getErrMsg());
    }

    public StreamSink getSinkInfo(Integer sinkId) {
        Response<StreamSink> response = ClientUtils.executeHttpCall(this.streamSinkApi.get(sinkId));
        ClientUtils.assertRespSuccess(response);
        return (StreamSink)response.getData();
    }

    public List<SinkField> parseFields(ParseFieldRequest parseFieldRequest) {
        Response<List<SinkField>> response = ClientUtils.executeHttpCall(this.streamSinkApi.parseFields(parseFieldRequest));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public List<SinkField> parseFields(String method, String statement) {
        Preconditions.expectTrue(("json".equals(method) || "sql".equals(method) ? 1 : 0) != 0, (String)("Unsupported parse field method: '" + method + "'"));
        Preconditions.expectNotBlank((String)statement, (String)"The statement must not empty");
        ParseFieldRequest request = ParseFieldRequest.builder().method(method).statement(statement).build();
        return this.parseFields(request);
    }
}

