/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.tool.reporter;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.audit.tool.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryReporter
implements MetricReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryReporter.class);
    protected SdkMeterProvider meterProvider;
    public Meter meter;
    public LongCounter alertCounter;
    public final Map<Attributes, Double> dataLossRateValues = new ConcurrentHashMap();

    public void init(Map<String, Object> config) {
        String endpoint = (String)config.getOrDefault("otel.exporter.endpoint", "http://localhost:4317");
        OtlpGrpcMetricExporter metricExporter = OtlpGrpcMetricExporter.builder().setEndpoint(endpoint).build();
        this.meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)PeriodicMetricReader.builder((MetricExporter)metricExporter).setInterval(Duration.ofSeconds(30L)).build()).build();
        this.meter = this.meterProvider.get("audit-tool");
        this.alertCounter = this.meter.counterBuilder("audit_tool_alerts_total").setDescription("Total number of alerts").build();
        this.meter.gaugeBuilder("audit_tool_data_loss_rate").setDescription("Data loss rate between Sort and DataProxy").buildWithCallback(measurement -> this.dataLossRateValues.forEach((attributes, value) -> measurement.record(value.doubleValue(), attributes)));
    }
}

