/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLTask.class);
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
    private boolean isAdded = false;
    public static final int DEFAULT_INSTANCE_LIMIT = 1;
    private String dbName;
    private String tableName;
    private String instanceId;

    @Override
    protected void initTask() {
        LOGGER.info("postgres commonInit: {}", (Object)this.taskProfile.toJsonStr());
        this.dbName = this.taskProfile.get("task.postgreSQLTask.dbname");
        this.tableName = this.taskProfile.get("task.postgreSQLTask.tableIncludeList");
        this.instanceId = this.dbName + "-" + this.tableName;
    }

    public boolean isProfileValid(TaskProfile profile) {
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.hostname"))) {
            LOGGER.error("task profile needs hostname");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.port"))) {
            LOGGER.error("task profile needs port");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.user"))) {
            LOGGER.error("task profile needs username");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.password"))) {
            LOGGER.error("task profile needs password");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.dbname"))) {
            LOGGER.error("task profile needs DB name");
            return false;
        }
        if (!profile.hasKey(profile.get("task.postgreSQLTask.pluginName"))) {
            LOGGER.error("task profile needs plugin name");
            return false;
        }
        return true;
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        if (this.isAdded) {
            return list;
        }
        String dataTime = LocalDateTime.now().format(this.dateTimeFormatter);
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(this.instanceId, "H", dataTime, AgentUtils.getCurrentTime());
        list.add(instanceProfile);
        this.isAdded = true;
        return list;
    }

    @Override
    protected int getInstanceLimit() {
        return 1;
    }
}

