/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.installer.conf.InstallerConfiguration;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ExcuteLinux;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.pojo.agent.installer.ConfigResult;
import org.apache.inlong.common.pojo.agent.installer.ModuleConfig;
import org.apache.inlong.common.pojo.agent.installer.ModuleStateEnum;
import org.apache.inlong.common.pojo.agent.installer.PackageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager
extends AbstractDaemon {
    public static final int CONFIG_QUEUE_CAPACITY = 1;
    public static final int CORE_THREAD_SLEEP_TIME = 10000;
    public static final int DOWNLOAD_PACKAGE_READ_BUFF_SIZE = 0x100000;
    public static final String LOCAL_CONFIG_FILE = "modules.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleManager.class);
    public static final int MAX_MODULE_SIZE = 10;
    public static final int CHECK_PROCESS_TIMES = 20;
    private final InstallerConfiguration conf;
    private final String confPath;
    private final BlockingQueue<ConfigResult> configQueue;
    private String currentMd5 = "";
    private Integer currentVersion = -1;
    private Map<Integer, ModuleConfig> currentModules = new ConcurrentHashMap<Integer, ModuleConfig>();
    private static final GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Gson GSON = gsonBuilder.create();
    private HttpManager httpManager;

    public ModuleManager() {
        this.conf = InstallerConfiguration.getInstallerConf();
        this.confPath = this.conf.get("agent.home", AgentConstants.DEFAULT_AGENT_HOME) + "/conf/";
        this.configQueue = new LinkedBlockingQueue<ConfigResult>(1);
        if (!this.requiredKeys(this.conf)) {
            throw new RuntimeException("init module manager error, cannot find required key");
        }
    }

    public HttpManager getHttpManager(InstallerConfiguration conf) {
        String managerAddr = conf.get("agent.manager.addr");
        String managerHttpPrefixPath = conf.get("agent.manager.vip.http.prefix.path", "/inlong/manager/openapi");
        int timeout = conf.getInt("agent.manager.request.timeout", 30);
        String secretId = conf.get("agent.manager.auth.secretId");
        String secretKey = conf.get("agent.manager.auth.secretKey");
        return new HttpManager(managerAddr, managerHttpPrefixPath, timeout, secretId, secretKey);
    }

    private boolean requiredKeys(InstallerConfiguration conf) {
        return conf.hasKey("agent.manager.addr");
    }

    public void submitConfig(ConfigResult config) {
        if (!this.isConfigValid(config)) {
            LOGGER.error("config is invalid !");
            return;
        }
        this.configQueue.clear();
        for (int i = 0; i < config.getModuleList().size(); ++i) {
            LOGGER.info("submitModules index {} total {} {}", new Object[]{i, config.getModuleList().size(), GSON.toJson(config.getModuleList().get(i))});
        }
        this.configQueue.add(config);
    }

    private boolean isConfigValid(ConfigResult config) {
        if (config == null) {
            LOGGER.error("config is null!");
            return false;
        }
        if (config.getMd5() == null) {
            LOGGER.error("modules md5 should not be null!");
            return false;
        }
        if (config.getVersion() == null) {
            LOGGER.error("modules version should not be null!");
            return false;
        }
        if (config.getModuleList().isEmpty()) {
            LOGGER.error("module list should not be empty!");
            return false;
        }
        if (config.getModuleList().size() > 10) {
            LOGGER.error("module list {} over size {}!", (Object)config.getModuleList().size(), (Object)10);
            return false;
        }
        for (int i = 0; i < config.getModuleList().size(); ++i) {
            if (this.isModuleConfigValid((ModuleConfig)config.getModuleList().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isModuleConfigValid(ModuleConfig module) {
        if (module == null) {
            LOGGER.error("module should not be null!");
            return false;
        }
        if (module.getMd5() == null) {
            LOGGER.error("module md5 should not be null!");
            return false;
        }
        if (module.getName() == null) {
            LOGGER.error("module name should not be null!");
            return false;
        }
        if (module.getVersion() == null) {
            LOGGER.error("module version should not be null!");
            return false;
        }
        if (module.getInstallCommand() == null) {
            LOGGER.error("module install cmd should not be null!");
            return false;
        }
        if (module.getStartCommand() == null) {
            LOGGER.error("module start cmd should not be null!");
            return false;
        }
        if (module.getStopCommand() == null) {
            LOGGER.error("module stop cmd should not be null!");
            return false;
        }
        if (module.getCheckCommand() == null) {
            LOGGER.error("module check cmd should not be null!");
            return false;
        }
        return this.isPackageConfigValid(module.getPackageConfig());
    }

    private boolean isPackageConfigValid(PackageConfig packageConfig) {
        if (packageConfig == null) {
            LOGGER.error("module package config should not be null!");
            return false;
        }
        if (packageConfig.getMd5() == null) {
            LOGGER.error("package md5 should not be null!");
            return false;
        }
        if (packageConfig.getFileName() == null) {
            LOGGER.error("package file name should not be null!");
            return false;
        }
        if (packageConfig.getDownloadUrl() == null) {
            LOGGER.error("package url should not be null!");
            return false;
        }
        if (packageConfig.getStoragePath() == null) {
            LOGGER.error("package save path should not be null!");
            return false;
        }
        return true;
    }

    public String getCurrentMd5() {
        return this.currentMd5;
    }

    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public ModuleConfig getModule(Integer moduleId) {
        return this.currentModules.get(moduleId);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("module-manager-core");
            this.restoreFromLocalFile(this.confPath);
            while (this.isRunnable()) {
                try {
                    this.dealWithConfigQueue(this.configQueue);
                    this.checkModules();
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_TASK_MGR_HEARTBEAT, (String)"", (String)"", (long)AgentUtils.getCurrentTime(), (int)1, (long)1L);
                    AgentUtils.silenceSleepInMs((long)10000L);
                }
                catch (Throwable ex) {
                    LOGGER.error("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                    AgentUtils.silenceSleepInMs((long)10000L);
                }
            }
        };
    }

    public void restoreFromLocalFile(String confPath) {
        LOGGER.info("restore modules from local file");
        String localModuleConfigPath = confPath + LOCAL_CONFIG_FILE;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(localModuleConfigPath), StandardCharsets.UTF_8);){
            JsonObject tmpElement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            ConfigResult curConfig = (ConfigResult)GSON.fromJson((JsonElement)tmpElement.getAsJsonObject(), ConfigResult.class);
            if (curConfig.getModuleList() != null) {
                if (curConfig.getMd5() != null) {
                    this.currentMd5 = curConfig.getMd5();
                }
                if (curConfig.getVersion() != null) {
                    this.currentVersion = curConfig.getVersion();
                }
                curConfig.getModuleList().forEach(module -> this.currentModules.put(module.getId(), (ModuleConfig)module));
            } else {
                LOGGER.info("modules in local file invalid");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info("local module json file {} not found", (Object)localModuleConfigPath);
        }
        catch (Exception ioe) {
            LOGGER.error("error restoredFromLocalFile {}", (Object)localModuleConfigPath, (Object)ioe);
        }
    }

    public void saveToLocalFile(String confPath) {
        File temp = new File(confPath);
        if (!temp.exists()) {
            temp.mkdirs();
        }
        File jsonPath = new File(temp.getPath() + "/" + LOCAL_CONFIG_FILE);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsonPath), StandardCharsets.UTF_8));){
            String curConfig = GSON.toJson((Object)ConfigResult.builder().md5(this.currentMd5).version(this.currentVersion).moduleList(this.currentModules.values().stream().collect(Collectors.toList())).build());
            writer.write(curConfig);
            writer.flush();
            LOGGER.info("save modules to json file");
        }
        catch (IOException e) {
            LOGGER.error("saveToLocalFile error: ", (Throwable)e);
        }
    }

    private void dealWithConfigQueue(BlockingQueue<ConfigResult> queue) {
        ConfigResult config = (ConfigResult)queue.poll();
        if (config == null) {
            return;
        }
        LOGGER.info("deal with config {}", (Object)GSON.toJson((Object)config));
        if (this.currentMd5.equals(config.getMd5())) {
            LOGGER.info("md5 no change {}, skip update", (Object)this.currentMd5);
            return;
        }
        if (this.updateModules(config.getModuleList())) {
            this.currentMd5 = config.getMd5();
            this.currentVersion = config.getVersion();
            this.saveToLocalFile(this.confPath);
        } else {
            LOGGER.error("update modules failed!");
        }
    }

    private void checkModules() {
        LOGGER.info("check modules start");
        this.currentModules.values().forEach(module -> {
            LOGGER.info("check module {}({}) current state {}", new Object[]{module.getId(), module.getName(), module.getState()});
            switch (module.getState()) {
                case NEW: {
                    if (this.downloadModule((ModuleConfig)module)) {
                        this.saveModuleState(module.getId(), ModuleStateEnum.DOWNLOADED);
                        break;
                    }
                    LOGGER.error("download module {}({}) failed, keep state in new", (Object)module.getId(), (Object)module.getName());
                    break;
                }
                case DOWNLOADED: {
                    if (this.isPackageDownloaded((ModuleConfig)module)) {
                        this.installModule((ModuleConfig)module);
                        this.saveModuleState(module.getId(), ModuleStateEnum.INSTALLED);
                        break;
                    }
                    LOGGER.info("check module {}({}) package failed, change stated to new, will download package again", (Object)module.getId(), (Object)module.getName());
                    this.saveModuleState(module.getId(), ModuleStateEnum.NEW);
                    break;
                }
                case INSTALLED: {
                    if (this.isProcessAllStarted((ModuleConfig)module, 20)) break;
                    LOGGER.info("module {}({}) process not all started try to start", (Object)module.getId(), (Object)module.getName());
                    if (this.startModule((ModuleConfig)module)) break;
                    LOGGER.info("start module {}({}) failed, change state to downloaded", (Object)module.getId(), (Object)module.getName());
                    this.saveModuleState(module.getId(), ModuleStateEnum.DOWNLOADED);
                    break;
                }
                default: {
                    LOGGER.error("module {}({}) invalid state {}", new Object[]{module.getId(), module.getName(), module.getState()});
                }
            }
        });
        LOGGER.info("check modules end");
    }

    private boolean updateModules(List<ModuleConfig> managerModuleList) {
        ConcurrentHashMap<Integer, ModuleConfig> modulesFromManager = new ConcurrentHashMap<Integer, ModuleConfig>();
        managerModuleList.forEach(moduleConfig -> modulesFromManager.put(moduleConfig.getId(), (ModuleConfig)moduleConfig));
        this.traverseManagerModulesToLocal(modulesFromManager);
        this.traverseLocalModulesToManager(modulesFromManager);
        return true;
    }

    private void traverseManagerModulesToLocal(Map<Integer, ModuleConfig> modulesFromManager) {
        modulesFromManager.values().forEach(managerModule -> {
            ModuleConfig localModule = this.currentModules.get(managerModule.getId());
            if (localModule == null) {
                LOGGER.info("traverseManagerModulesToLocal module {}({}) {} not found in local, add it", new Object[]{managerModule.getId(), managerModule.getName(), managerModule.getVersion()});
                this.addModule((ModuleConfig)managerModule);
            } else if (managerModule.getMd5().equals(localModule.getMd5())) {
                LOGGER.info("traverseManagerModulesToLocal module {}({}) {} md5 no change, do nothing", new Object[]{localModule.getId(), localModule.getName(), localModule.getVersion()});
            } else {
                LOGGER.info("traverseManagerModulesToLocal module {}({}) {} md5 changed, update it", new Object[]{localModule.getId(), localModule.getName(), localModule.getVersion()});
                this.updateModule(localModule, (ModuleConfig)managerModule);
            }
        });
    }

    private void traverseLocalModulesToManager(Map<Integer, ModuleConfig> modulesFromManager) {
        this.currentModules.values().forEach(localModule -> {
            ModuleConfig managerModule = (ModuleConfig)modulesFromManager.get(localModule.getId());
            if (managerModule == null) {
                LOGGER.info("traverseLocalModulesToManager module {}({}) {} not found in local, delete it", new Object[]{localModule.getId(), localModule.getName(), localModule.getVersion()});
                this.deleteModule((ModuleConfig)localModule);
            }
        });
    }

    private void addModule(ModuleConfig module) {
        LOGGER.info("add module {}({}) start", (Object)module.getId(), (Object)module.getName());
        this.addAndSaveModuleConfig(module);
        if (!this.downloadModule(module)) {
            LOGGER.error("add module {}({}) but download failed", (Object)module.getId(), (Object)module.getName());
            return;
        }
        this.saveModuleState(module.getId(), ModuleStateEnum.DOWNLOADED);
        this.installModule(module);
        this.saveModuleState(module.getId(), ModuleStateEnum.INSTALLED);
        this.startModule(module);
        LOGGER.info("add module {}({}) end", (Object)module.getId(), (Object)module.getName());
    }

    private void deleteModule(ModuleConfig module) {
        LOGGER.info("delete module {}({}) start", (Object)module.getId(), (Object)module.getName());
        this.stopModule(module);
        this.uninstallModule(module);
        this.deleteAndSaveModuleConfig(module);
        LOGGER.info("delete module {}({}) end", (Object)module.getId(), (Object)module.getName());
    }

    private void updateModule(ModuleConfig localModule, ModuleConfig managerModule) {
        LOGGER.info("update module {}({}) start", (Object)localModule.getId(), (Object)localModule.getName());
        if (localModule.getPackageConfig().getMd5().equals(managerModule.getPackageConfig().getMd5())) {
            LOGGER.info("module {}({}) package md5 no change, will restart and save config", (Object)localModule.getId(), (Object)localModule.getName());
            this.restartModule(localModule, managerModule);
            managerModule.setState(localModule.getState());
            this.updateModuleConfig(managerModule);
        } else {
            LOGGER.info("module {}({}) package md5 changed, will reinstall", (Object)localModule.getId(), (Object)localModule.getName());
            this.deleteModule(localModule);
            this.addModule(managerModule);
        }
        LOGGER.info("update module {}({}) end", (Object)localModule.getId(), (Object)localModule.getName());
    }

    private void addAndSaveModuleConfig(ModuleConfig module) {
        module.setState(ModuleStateEnum.NEW);
        if (this.currentModules.containsKey(module.getId())) {
            LOGGER.error("should not happen! module {}({}) found! will force to replace it!", (Object)module.getId(), (Object)module.getName());
        }
        this.currentModules.put(module.getId(), module);
        this.saveToLocalFile(this.confPath);
    }

    private void deleteAndSaveModuleConfig(ModuleConfig module) {
        if (!this.currentModules.containsKey(module.getId())) {
            LOGGER.error("should not happen! module {}({}) not found!", (Object)module.getId(), (Object)module.getName());
            return;
        }
        this.currentModules.remove(module.getId());
        this.saveToLocalFile(this.confPath);
    }

    private void updateModuleConfig(ModuleConfig module) {
        this.currentModules.put(module.getId(), module);
        this.saveToLocalFile(this.confPath);
    }

    private boolean saveModuleState(Integer moduleId, ModuleStateEnum state) {
        ModuleConfig module = this.currentModules.get(moduleId);
        if (module == null) {
            LOGGER.error("should not happen! module {} not found!", (Object)moduleId);
            return false;
        }
        module.setState(state);
        this.saveToLocalFile(this.confPath);
        LOGGER.info("save module {}({}) state to {}", new Object[]{module.getId(), module.getName(), state});
        return true;
    }

    private void restartModule(ModuleConfig localModule, ModuleConfig managerModule) {
        this.stopModule(localModule);
        this.startModule(managerModule);
    }

    private void installModule(ModuleConfig module) {
        LOGGER.info("install module {}({}) with cmd {}", new Object[]{module.getId(), module.getName(), module.getInstallCommand()});
        String ret = ExcuteLinux.exeCmd((String)module.getInstallCommand());
        LOGGER.info("install module {}({}) return {} ", new Object[]{module.getId(), module.getName(), ret});
    }

    private boolean startModule(ModuleConfig module) {
        LOGGER.info("start module {}({}) with cmd {}", new Object[]{module.getId(), module.getName(), module.getStartCommand()});
        for (int i = 0; i < module.getProcessesNum(); ++i) {
            String ret = ExcuteLinux.exeCmd((String)module.getStartCommand());
            LOGGER.info("start module {}({}) proc[{}] return {} ", new Object[]{module.getId(), module.getName(), i, ret});
        }
        if (this.isProcessAllStarted(module, 20)) {
            LOGGER.info("start module {}({}) success", (Object)module.getId(), (Object)module.getName());
            return true;
        }
        LOGGER.info("start module {}({}) failed", (Object)module.getId(), (Object)module.getName());
        return false;
    }

    private void stopModule(ModuleConfig module) {
        LOGGER.info("stop module {}({}) with cmd {}", new Object[]{module.getId(), module.getName(), module.getStopCommand()});
        String ret = ExcuteLinux.exeCmd((String)module.getStopCommand());
        LOGGER.info("stop module {}({}) return {} ", new Object[]{module.getId(), module.getName(), ret});
    }

    private void uninstallModule(ModuleConfig module) {
        LOGGER.info("uninstall module {}({}) with cmd {}", new Object[]{module.getId(), module.getName(), module.getUninstallCommand()});
        String ret = ExcuteLinux.exeCmd((String)module.getUninstallCommand());
        LOGGER.info("uninstall module {}({}) return {} ", new Object[]{module.getId(), module.getName(), ret});
    }

    private boolean isProcessAllStarted(ModuleConfig module, int times) {
        for (int check = 0; check < times; ++check) {
            AgentUtils.silenceSleepInSeconds((long)1L);
            String ret = ExcuteLinux.exeCmd((String)module.getCheckCommand());
            if (ret == null) {
                LOGGER.error("[{}] get module {}({}) process num failed", new Object[]{check, module.getId(), module.getName()});
                continue;
            }
            String[] processArray = ret.split("\n");
            int cnt = 0;
            for (int i = 0; i < processArray.length; ++i) {
                if (processArray[i].length() <= 0) continue;
                ++cnt;
            }
            LOGGER.info("[{}] get module {}({}) process num {}", new Object[]{check, module.getId(), module.getName(), cnt});
            if (cnt < module.getProcessesNum()) continue;
            return true;
        }
        return false;
    }

    private boolean downloadModule(ModuleConfig module) {
        LOGGER.info("download module {}({}) begin with url {}", new Object[]{module.getId(), module.getName(), module.getPackageConfig().getDownloadUrl()});
        try {
            URL url = new URL(module.getPackageConfig().getDownloadUrl());
            URLConnection conn = url.openConnection();
            Map authHeader = this.httpManager.getAuthHeader();
            authHeader.forEach((k, v) -> conn.setRequestProperty((String)k, (String)v));
            String saveFolder = this.getRealPath(module.getPackageConfig().getStoragePath());
            File folder = new File(saveFolder);
            if (!folder.exists()) {
                boolean folderCreated = folder.mkdirs();
                if (folderCreated) {
                    LOGGER.info("saveFolder {} created", (Object)saveFolder);
                } else {
                    LOGGER.error("failed to create saveFolder {}", (Object)saveFolder);
                }
            }
            String path = saveFolder + "/" + module.getPackageConfig().getFileName();
            try (InputStream inputStream = conn.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(path);){
                int byteRead;
                LOGGER.info("module {}({}) save path {}", new Object[]{module.getId(), module.getName(), path});
                byte[] buffer = new byte[0x100000];
                while ((byteRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, byteRead);
                }
            }
            if (this.isPackageDownloaded(module)) {
                return true;
            }
            LOGGER.error("download module {}({}) package md5 not match!", (Object)module.getId(), (Object)module.getName());
            return false;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("download module {}({}) err", new Object[]{module.getId(), module.getName(), e});
        }
        catch (IOException e) {
            LOGGER.error("download module {}({}) err", new Object[]{module.getId(), module.getName(), e});
        }
        LOGGER.info("download module {}({}) end", (Object)module.getId(), (Object)module.getName());
        return false;
    }

    private boolean isPackageDownloaded(ModuleConfig module) {
        String path = this.getRealPath(module.getPackageConfig().getStoragePath()) + "/" + module.getPackageConfig().getFileName();
        String fileMd5 = ModuleManager.calcFileMd5(path);
        if (Objects.equals(fileMd5, module.getPackageConfig().getMd5())) {
            return true;
        }
        LOGGER.error("module {}({}) md5 not match! fileMd5 {} moduleMd5 {}", new Object[]{module.getId(), module.getName(), fileMd5, module.getPackageConfig().getMd5()});
        return false;
    }

    private String getRealPath(String originPath) {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            LOGGER.warn("user.home should not be null");
            return originPath;
        }
        return originPath.replace("~", homeDir).replace("${HOME}", homeDir).replace("${home}", homeDir);
    }

    public void start() throws Exception {
        this.httpManager = this.getHttpManager(this.conf);
        this.submitWorker(this.coreThread());
    }

    public void join() {
        super.join();
    }

    public void stop() throws Exception {
        this.waitForTerminate();
    }

    private static String calcFileMd5(String path) {
        byte[] buffer = new byte[0x100000];
        int len = 0;
        String ret = null;
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            MessageDigest md = MessageDigest.getInstance("MD5");
            while ((len = fileInputStream.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            ret = new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("calc file md5 NoSuchAlgorithmException", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("calc file md5 IOException", (Throwable)e);
        }
        return ret;
    }
}

