/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.common.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDaemon
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDaemon.class);
    private static final ExecutorService WORKER_SERVICES = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new AgentThreadFactory("AbstractDaemon"));
    private final List<CompletableFuture<?>> workerFutures = new ArrayList();
    private volatile boolean runnable = true;

    public boolean isRunnable() {
        return this.runnable;
    }

    public void stopRunningThreads() {
        this.runnable = false;
    }

    public void submitWorker(Runnable worker) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(worker, WORKER_SERVICES);
        this.workerFutures.add(future);
        LOGGER.info("{} running worker number is {}", (Object)this.getClass().getName(), (Object)this.workerFutures.size());
    }

    @Override
    public void join() {
        for (CompletableFuture<?> future : this.workerFutures) {
            future.join();
        }
    }

    public void waitForTerminate() {
        if (this.isRunnable()) {
            this.stopRunningThreads();
        }
    }
}

