/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsAdapter;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.DataStorageMetricsAdapter;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCluster;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteEncryption;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.IgniteSnapshot;
import org.apache.ignite.IgniteSpring;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.MemoryMetrics;
import org.apache.ignite.PersistenceMetrics;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.IgnitePlugin;
import org.apache.ignite.plugin.PluginNotFoundException;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IgniteSpringBean
implements Ignite,
DisposableBean,
SmartInitializingSingleton,
ApplicationContextAware,
Externalizable {
    private static final long serialVersionUID = 0L;
    private Ignite g;
    private IgniteConfiguration cfg;
    private ApplicationContext appCtx;

    public IgniteConfiguration configuration() {
        return this.cfg;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    public ApplicationContext getApplicationContext() throws BeansException {
        return this.appCtx;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.appCtx = ctx;
    }

    public void destroy() throws Exception {
        if (this.g != null) {
            G.stop((String)this.g.name(), (boolean)false);
        }
    }

    public void afterSingletonsInstantiated() {
        if (this.cfg == null) {
            this.cfg = new IgniteConfiguration();
        }
        try {
            this.g = IgniteSpring.start(this.cfg, this.appCtx);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to start IgniteSpringBean", (Throwable)e);
        }
    }

    public IgniteLogger log() {
        this.checkIgnite();
        return this.cfg.getGridLogger();
    }

    public IgniteProductVersion version() {
        this.checkIgnite();
        return this.g.version();
    }

    public IgniteCompute compute() {
        this.checkIgnite();
        return this.g.compute();
    }

    public IgniteServices services() {
        this.checkIgnite();
        return this.g.services();
    }

    public IgniteMessaging message() {
        this.checkIgnite();
        return this.g.message();
    }

    public IgniteEvents events() {
        this.checkIgnite();
        return this.g.events();
    }

    public ExecutorService executorService() {
        this.checkIgnite();
        return this.g.executorService();
    }

    public IgniteCluster cluster() {
        this.checkIgnite();
        return this.g.cluster();
    }

    public IgniteCompute compute(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.compute(grp);
    }

    public IgniteMessaging message(ClusterGroup prj) {
        this.checkIgnite();
        return this.g.message(prj);
    }

    public IgniteEvents events(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.events(grp);
    }

    public IgniteServices services(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.services(grp);
    }

    public ExecutorService executorService(ClusterGroup grp) {
        this.checkIgnite();
        return this.g.executorService(grp);
    }

    public IgniteScheduler scheduler() {
        this.checkIgnite();
        return this.g.scheduler();
    }

    public String name() {
        this.checkIgnite();
        return this.g.name();
    }

    public void resetLostPartitions(Collection<String> cacheNames) {
        this.checkIgnite();
        this.g.resetLostPartitions(cacheNames);
    }

    public Collection<DataRegionMetrics> dataRegionMetrics() {
        this.checkIgnite();
        return this.g.dataRegionMetrics();
    }

    @Nullable
    public DataRegionMetrics dataRegionMetrics(String memPlcName) {
        this.checkIgnite();
        return this.g.dataRegionMetrics(memPlcName);
    }

    public DataStorageMetrics dataStorageMetrics() {
        this.checkIgnite();
        return this.g.dataStorageMetrics();
    }

    public IgniteEncryption encryption() {
        this.checkIgnite();
        return this.g.encryption();
    }

    public IgniteSnapshot snapshot() {
        return this.g.snapshot();
    }

    @NotNull
    public TracingConfigurationManager tracingConfiguration() {
        this.checkIgnite();
        return this.g.tracingConfiguration();
    }

    public Collection<MemoryMetrics> memoryMetrics() {
        return DataRegionMetricsAdapter.collectionOf(this.dataRegionMetrics());
    }

    @Nullable
    public MemoryMetrics memoryMetrics(String memPlcName) {
        return DataRegionMetricsAdapter.valueOf((DataRegionMetrics)this.dataRegionMetrics(memPlcName));
    }

    public PersistenceMetrics persistentStoreMetrics() {
        return DataStorageMetricsAdapter.valueOf((DataStorageMetrics)this.dataStorageMetrics());
    }

    public <K, V> IgniteCache<K, V> cache(@Nullable String name) {
        this.checkIgnite();
        return this.g.cache(name);
    }

    public Collection<String> cacheNames() {
        this.checkIgnite();
        return this.g.cacheNames();
    }

    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        return this.g.createCache(cacheCfg);
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheCfg);
    }

    public <K, V> IgniteCache<K, V> createCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.createCache(cacheCfg, nearCfg);
    }

    public Collection<IgniteCache> createCaches(Collection<CacheConfiguration> cacheCfgs) {
        this.checkIgnite();
        return this.g.createCaches(cacheCfgs);
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(CacheConfiguration<K, V> cacheCfg, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheCfg, nearCfg);
    }

    public <K, V> IgniteCache<K, V> createNearCache(String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.createNearCache(cacheName, nearCfg);
    }

    public <K, V> IgniteCache<K, V> getOrCreateNearCache(@Nullable String cacheName, NearCacheConfiguration<K, V> nearCfg) {
        this.checkIgnite();
        return this.g.getOrCreateNearCache(cacheName, nearCfg);
    }

    public <K, V> IgniteCache<K, V> getOrCreateCache(String cacheName) {
        this.checkIgnite();
        return this.g.getOrCreateCache(cacheName);
    }

    public Collection<IgniteCache> getOrCreateCaches(Collection<CacheConfiguration> cacheCfgs) {
        this.checkIgnite();
        return this.g.getOrCreateCaches(cacheCfgs);
    }

    public <K, V> IgniteCache<K, V> createCache(String cacheName) {
        this.checkIgnite();
        return this.g.createCache(cacheName);
    }

    public <K, V> void addCacheConfiguration(CacheConfiguration<K, V> cacheCfg) {
        this.checkIgnite();
        this.g.addCacheConfiguration(cacheCfg);
    }

    public void destroyCache(String cacheName) {
        this.checkIgnite();
        this.g.destroyCache(cacheName);
    }

    public void destroyCaches(Collection<String> cacheNames) {
        this.checkIgnite();
        this.g.destroyCaches(cacheNames);
    }

    public IgniteTransactions transactions() {
        this.checkIgnite();
        return this.g.transactions();
    }

    public <K, V> IgniteDataStreamer<K, V> dataStreamer(@Nullable String cacheName) {
        this.checkIgnite();
        return this.g.dataStreamer(cacheName);
    }

    public <T extends IgnitePlugin> T plugin(String name) throws PluginNotFoundException {
        this.checkIgnite();
        return (T)this.g.plugin(name);
    }

    public IgniteBinary binary() {
        this.checkIgnite();
        return this.g.binary();
    }

    public void close() throws IgniteException {
        this.g.close();
    }

    @Nullable
    public IgniteAtomicSequence atomicSequence(String name, long initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicSequence(name, initVal, create);
    }

    public IgniteAtomicSequence atomicSequence(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicSequence(name, cfg, initVal, create);
    }

    @Nullable
    public IgniteAtomicLong atomicLong(String name, long initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicLong(name, initVal, create);
    }

    public IgniteAtomicLong atomicLong(String name, AtomicConfiguration cfg, long initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicLong(name, cfg, initVal, create);
    }

    @Nullable
    public <T> IgniteAtomicReference<T> atomicReference(String name, @Nullable T initVal, boolean create) {
        this.checkIgnite();
        return this.g.atomicReference(name, initVal, create);
    }

    public <T> IgniteAtomicReference<T> atomicReference(String name, AtomicConfiguration cfg, @Nullable T initVal, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicReference(name, cfg, initVal, create);
    }

    @Nullable
    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, @Nullable T initVal, @Nullable S initStamp, boolean create) {
        this.checkIgnite();
        return this.g.atomicStamped(name, initVal, initStamp, create);
    }

    public <T, S> IgniteAtomicStamped<T, S> atomicStamped(String name, AtomicConfiguration cfg, @Nullable T initVal, @Nullable S initStamp, boolean create) throws IgniteException {
        this.checkIgnite();
        return this.g.atomicStamped(name, cfg, initVal, initStamp, create);
    }

    @Nullable
    public IgniteCountDownLatch countDownLatch(String name, int cnt, boolean autoDel, boolean create) {
        this.checkIgnite();
        return this.g.countDownLatch(name, cnt, autoDel, create);
    }

    @Nullable
    public IgniteSemaphore semaphore(String name, int cnt, boolean failoverSafe, boolean create) {
        this.checkIgnite();
        return this.g.semaphore(name, cnt, failoverSafe, create);
    }

    @Nullable
    public IgniteLock reentrantLock(String name, boolean failoverSafe, boolean fair, boolean create) {
        this.checkIgnite();
        return this.g.reentrantLock(name, failoverSafe, fair, create);
    }

    @Nullable
    public <T> IgniteQueue<T> queue(String name, int cap, CollectionConfiguration cfg) {
        this.checkIgnite();
        return this.g.queue(name, cap, cfg);
    }

    @Nullable
    public <T> IgniteSet<T> set(String name, CollectionConfiguration cfg) {
        this.checkIgnite();
        return this.g.set(name, cfg);
    }

    public <K> Affinity<K> affinity(String cacheName) {
        return this.g.affinity(cacheName);
    }

    public boolean active() {
        this.checkIgnite();
        return this.g.active();
    }

    public void active(boolean active) {
        this.checkIgnite();
        this.g.active(active);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.g);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.g = (Ignite)in.readObject();
        this.cfg = this.g.configuration();
    }

    protected void checkIgnite() throws IllegalStateException {
        if (this.g == null) {
            throw new IllegalStateException("Ignite is in invalid state to perform this operation. It either not started yet or has already being or have stopped.\nMake sure that IgniteSpringBean is not referenced from any kind of Spring bean init methods like @PostConstruct}.\n[ignite=" + this.g + ", cfg=" + this.cfg + ']');
        }
    }

    public String toString() {
        return S.toString(IgniteSpringBean.class, (Object)this);
    }
}

