/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;

public interface AddedRowsScanTask
extends ChangelogScanTask,
ContentScanTask<DataFile> {
    public List<DeleteFile> deletes();

    @Override
    default public ChangelogOperation operation() {
        return ChangelogOperation.INSERT;
    }

    @Override
    default public long sizeBytes() {
        return this.length() + this.deletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum();
    }

    @Override
    default public int filesCount() {
        return 1 + this.deletes().size();
    }
}

