/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.iterator;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.util.E;

public class FlatMapperFilterIterator<T, R>
extends FlatMapperIterator<T, R> {
    private final Function<R, Boolean> filterCallback;

    public FlatMapperFilterIterator(Iterator<T> origin, Function<T, Iterator<R>> mapper, Function<R, Boolean> filter) {
        super(origin, mapper);
        this.filterCallback = filter;
    }

    @Override
    protected final boolean fetchFromBatch() {
        E.checkNotNull(this.batchIterator, "mapper results");
        while (this.batchIterator.hasNext()) {
            Object result = this.batchIterator.next();
            if (result == null || !this.filterCallback.apply(result).booleanValue()) continue;
            assert (this.current == FlatMapperFilterIterator.none());
            this.current = result;
            return true;
        }
        this.resetBatchIterator();
        return false;
    }
}

