/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.util.CharsetUtil;

public class HttpMultipart
extends Multipart {
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;

    public HttpMultipart(String subType) {
        super(subType);
    }

    public HttpMultipartMode getMode() {
        return this.mode;
    }

    public void setMode(HttpMultipartMode mode) {
        this.mode = mode;
    }

    protected Charset getCharset() {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        Charset charset = null;
        switch (this.mode) {
            case STRICT: {
                charset = MIME.DEFAULT_CHARSET;
                break;
            }
            case BROWSER_COMPATIBLE: {
                charset = cField.getCharset() != null ? CharsetUtil.getCharset((String)cField.getCharset()) : CharsetUtil.getCharset((String)"ISO-8859-1");
            }
        }
        return charset;
    }

    protected String getBoundary() {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        return cField.getBoundary();
    }

    private void doWriteTo(HttpMultipartMode mode, OutputStream out, boolean writeContent) throws IOException {
        List bodyParts = this.getBodyParts();
        Charset charset = this.getCharset();
        String boundary = this.getBoundary();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset), 8192);
        switch (mode) {
            case STRICT: {
                String preamble = this.getPreamble();
                if (preamble != null && preamble.length() != 0) {
                    writer.write(preamble);
                    writer.write("\r\n");
                }
                for (int i = 0; i < bodyParts.size(); ++i) {
                    writer.write("--");
                    writer.write(boundary);
                    writer.write("\r\n");
                    writer.flush();
                    BodyPart part = (BodyPart)bodyParts.get(i);
                    part.getHeader().writeTo(out, 1);
                    if (writeContent) {
                        part.getBody().writeTo(out, 1);
                    }
                    writer.write("\r\n");
                }
                writer.write("--");
                writer.write(boundary);
                writer.write("--\r\n");
                String epilogue = this.getEpilogue();
                if (epilogue != null && epilogue.length() != 0) {
                    writer.write(epilogue);
                    writer.write("\r\n");
                }
                writer.flush();
                break;
            }
            case BROWSER_COMPATIBLE: {
                for (int i = 0; i < bodyParts.size(); ++i) {
                    writer.write("--");
                    writer.write(boundary);
                    writer.write("\r\n");
                    writer.flush();
                    BodyPart part = (BodyPart)bodyParts.get(i);
                    Field cd = part.getHeader().getField("Content-Disposition");
                    writer.write(cd.toString());
                    writer.write("\r\n");
                    writer.write("\r\n");
                    writer.flush();
                    if (writeContent) {
                        part.getBody().writeTo(out, 3);
                    }
                    writer.write("\r\n");
                }
                writer.write("--");
                writer.write(boundary);
                writer.write("--\r\n");
                writer.flush();
            }
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.doWriteTo(this.mode, out, true);
    }

    public void writeTo(OutputStream out, int mode) throws IOException, MimeException {
        if (mode == 3) {
            this.doWriteTo(HttpMultipartMode.BROWSER_COMPATIBLE, out, true);
        } else {
            this.doWriteTo(HttpMultipartMode.STRICT, out, true);
        }
    }

    public long getTotalLength() {
        List bodyParts = this.getBodyParts();
        long contentLen = 0L;
        for (int i = 0; i < bodyParts.size(); ++i) {
            BodyPart part = (BodyPart)bodyParts.get(i);
            Body body = part.getBody();
            if (body instanceof ContentBody) {
                long len = ((ContentBody)body).getContentLength();
                if (len >= 0L) {
                    contentLen += len;
                    continue;
                }
                return -1L;
            }
            return -1L;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.doWriteTo(this.mode, out, false);
            byte[] extra = out.toByteArray();
            return contentLen + (long)extra.length;
        }
        catch (IOException ex) {
            return -1L;
        }
    }
}

