/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.Comparator;
import java.util.Date;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookiePriorityComparator;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCookiePriorityComparator {
    private Comparator<Cookie> comparator;

    @Before
    public void setup() {
        this.comparator = CookiePriorityComparator.INSTANCE;
    }

    @Test
    public void testUnequality() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a/b/");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a/");
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquality() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a");
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnequalityTrailingSlash() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a/");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a");
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualityNullPath() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath(null);
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/");
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualitySameLength() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/this");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/that");
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnequalityCreationDate() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/blah");
        cookie1.setCreationDate(new Date(System.currentTimeMillis() - 200000L));
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/blah");
        cookie2.setCreationDate(new Date(System.currentTimeMillis()));
        Assert.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }
}

