/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

public class HttpState {
    private final HashMap credMap = new HashMap();
    private final ArrayList cookies = new ArrayList();
    private final Comparator cookieComparator = new CookieIdentityComparator();

    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator it = this.cookies.iterator();
            while (it.hasNext()) {
                Cookie tmp = (Cookie)it.next();
                if (this.cookieComparator.compare(cookie, tmp) != 0) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.addCookie(cookies[i]);
            }
        }
    }

    public synchronized Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized boolean purgeExpiredCookies() {
        boolean removed = false;
        Date now = new Date();
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!((Cookie)it.next()).isExpired(now)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        this.credMap.put(authscope, credentials);
    }

    private static Credentials matchCredentials(HashMap map, AuthScope authscope) {
        Credentials creds = (Credentials)map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            Iterator items = map.keySet().iterator();
            while (items.hasNext()) {
                AuthScope current = (AuthScope)items.next();
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = (Credentials)map.get(bestMatch);
            }
        }
        return creds;
    }

    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return HttpState.matchCredentials(this.credMap, authscope);
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.credMap);
        buffer.append(this.cookies);
        return buffer.toString();
    }

    public synchronized void clearCredentials() {
        this.credMap.clear();
    }

    public synchronized void clearCookies() {
        this.cookies.clear();
    }

    public synchronized void clear() {
        this.clearCookies();
        this.clearCredentials();
    }
}

