/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.impl.client.cache.AsynchronousValidationRequest;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheKeyGenerator;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.DefaultFailureCache;
import org.apache.http.impl.client.cache.FailureCache;
import org.apache.http.impl.client.cache.ImmediateSchedulingStrategy;
import org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class AsynchronousValidator {
    private final CachingHttpClient cachingClient;
    private final SchedulingStrategy schedulingStrategy;
    private final Set<String> queued;
    private final CacheKeyGenerator cacheKeyGenerator;
    private final FailureCache failureCache;
    private final Log log = LogFactory.getLog(this.getClass());

    public AsynchronousValidator(CachingHttpClient cachingClient, CacheConfig config) {
        this(cachingClient, new ImmediateSchedulingStrategy(config));
    }

    AsynchronousValidator(CachingHttpClient cachingClient, SchedulingStrategy schedulingStrategy) {
        this.cachingClient = cachingClient;
        this.queued = new HashSet<String>();
        this.cacheKeyGenerator = new CacheKeyGenerator();
        this.schedulingStrategy = schedulingStrategy;
        this.failureCache = new DefaultFailureCache();
    }

    public synchronized void revalidateCacheEntry(HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry entry) {
        String uri = this.cacheKeyGenerator.getVariantURI(target, request, entry);
        if (!this.queued.contains(uri)) {
            int consecutiveFailedAttempts = this.failureCache.getErrorCount(uri);
            AsynchronousValidationRequest revalidationRequest = new AsynchronousValidationRequest(this, this.cachingClient, target, request, context, entry, uri, consecutiveFailedAttempts);
            try {
                this.schedulingStrategy.schedule(revalidationRequest);
                this.queued.add(uri);
            }
            catch (RejectedExecutionException ree) {
                this.log.debug((Object)("Revalidation for [" + uri + "] not scheduled: " + ree));
            }
        }
    }

    synchronized void markComplete(String identifier) {
        this.queued.remove(identifier);
    }

    void jobSuccessful(String identifier) {
        this.failureCache.resetErrorCount(identifier);
    }

    void jobFailed(String identifier) {
        this.failureCache.increaseErrorCount(identifier);
    }

    Set<String> getScheduledIdentifiers() {
        return Collections.unmodifiableSet(this.queued);
    }

    public void shutdown() {
        this.schedulingStrategy.shutdown();
    }
}

