/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.classic.methods;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;

public class HttpUriRequestBase
extends BasicClassicHttpRequest
implements HttpUriRequest,
CancellableDependency {
    private static final long serialVersionUID = 1L;
    private RequestConfig requestConfig;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicReference<Cancellable> cancellableRef = new AtomicReference<Object>(null);

    public HttpUriRequestBase(String method, URI requestUri) {
        super(method, requestUri);
    }

    public boolean cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            Cancellable cancellable = this.cancellableRef.getAndSet(null);
            if (cancellable != null) {
                cancellable.cancel();
            }
            return true;
        }
        return false;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setDependency(Cancellable cancellable) {
        if (!this.cancelled.get()) {
            this.cancellableRef.set(cancellable);
        }
    }

    public void reset() {
        Cancellable cancellable = this.cancellableRef.getAndSet(null);
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.cancelled.set(false);
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        this.cancel();
    }

    @Override
    public boolean isAborted() {
        return this.isCancelled();
    }

    public void setConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Override
    public RequestConfig getConfig() {
        return this.requestConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMethod()).append(" ").append(this.getRequestUri());
        return sb.toString();
    }
}

