/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.impl.auth.GGSSchemeBase;
import org.apache.hc.core5.annotation.NotThreadSafe;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(DnsResolver dnsResolver, boolean stripPort, boolean useCanonicalHostname) {
        super(dnsResolver, stripPort, useCanonicalHostname);
    }

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
    }

    @Override
    public String getName() {
        return "Kerberos";
    }

    @Override
    protected byte[] generateToken(byte[] input, String serviceName, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), serviceName, authServer);
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }
}

