/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;

public class Executor {
    static final CloseableHttpClient CLIENT = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties().setMaxConnPerRoute(100).setMaxConnTotal(200).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes((long)1L)).build();
    private final CloseableHttpClient httpclient;
    private final AuthCache authCache;
    private volatile CredentialsStore credentialsStore;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(CloseableHttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        if (this.credentialsStore == null) {
            this.credentialsStore = new BasicCredentialsProvider();
        }
        this.credentialsStore.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host, Credentials creds) {
        return this.auth(new AuthScope(host), creds);
    }

    public Executor auth(String host, Credentials creds) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.auth(httpHost, creds);
    }

    public Executor authPreemptive(HttpHost host) {
        Credentials credentials;
        if (this.credentialsStore != null && (credentials = this.credentialsStore.getCredentials(new AuthScope(host), null)) == null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(host, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptive(String host) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.authPreemptive(httpHost);
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        Credentials credentials;
        if (this.credentialsStore != null && (credentials = this.credentialsStore.getCredentials(new AuthScope(proxy), null)) == null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(proxy, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create((String)proxy);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + proxy);
        }
        return this.authPreemptiveProxy(httpHost);
    }

    public Executor auth(HttpHost host, String username, char[] password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, char[] password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        if (this.credentialsStore != null) {
            this.credentialsStore.clear();
        }
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) throws IOException {
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentialsStore != null) {
            localContext.setAttribute("http.auth.credentials-provider", (Object)this.credentialsStore);
        }
        if (this.authCache != null) {
            localContext.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        }
        if (this.cookieStore != null) {
            localContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
        }
        return new Response(request.internalExecute(this.httpclient, localContext));
    }
}

