/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheEntrySerializer;
import org.apache.hc.client5.http.cache.HttpCacheStorageEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.HeapResource;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.AbstractMessageWriter;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.message.BasicLineFormatter;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.message.LineFormatter;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class HttpByteArrayCacheEntrySerializer
implements HttpCacheEntrySerializer<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpByteArrayCacheEntrySerializer.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    static final String HC_CACHE_VERSION = "1.0";
    static final String HC_CACHE_VERSION_LINE = "HttpClient CacheEntry 1.0";
    static final String HC_CACHE_KEY = "HC-Key";
    static final String HC_CACHE_LENGTH = "HC-Resource-Length";
    static final String HC_REQUEST_INSTANT = "HC-Request-Instant";
    static final String HC_RESPONSE_INSTANT = "HC-Response-Instant";
    static final String HC_VARIANT = "HC-Variant";
    public static final HttpByteArrayCacheEntrySerializer INSTANCE = new HttpByteArrayCacheEntrySerializer();
    private final LineParser lineParser = BasicLineParser.INSTANCE;
    private final LineFormatter lineFormatter = BasicLineFormatter.INSTANCE;
    private final int bufferSize;

    public HttpByteArrayCacheEntrySerializer(int bufferSize) {
        this.bufferSize = bufferSize > 0 ? bufferSize : 8192;
    }

    public HttpByteArrayCacheEntrySerializer() {
        this(8192);
    }

    @Override
    public byte[] serialize(HttpCacheStorageEntry storageEntry) throws ResourceIOException {
        byte[] byArray;
        String key = storageEntry.getKey();
        HttpCacheEntry cacheEntry = storageEntry.getContent();
        Resource resource = cacheEntry.getResource();
        ByteArrayOutputStream out = new ByteArrayOutputStream((resource != null ? (int)resource.length() : 0) + 8192);
        try {
            SessionOutputBufferImpl outputBuffer = new SessionOutputBufferImpl(this.bufferSize);
            CharArrayBuffer line = new CharArrayBuffer(8192);
            line.append(HC_CACHE_VERSION_LINE);
            outputBuffer.writeLine(line, (OutputStream)out);
            line.clear();
            line.append(HC_CACHE_KEY);
            line.append(": ");
            line.append(key);
            outputBuffer.writeLine(line, (OutputStream)out);
            if (resource != null) {
                line.clear();
                line.append(HC_CACHE_LENGTH);
                line.append(": ");
                line.append(HttpByteArrayCacheEntrySerializer.asStr(resource.length()));
                outputBuffer.writeLine(line, (OutputStream)out);
            }
            line.clear();
            line.append(HC_REQUEST_INSTANT);
            line.append(": ");
            line.append(HttpByteArrayCacheEntrySerializer.asStr(cacheEntry.getRequestInstant()));
            outputBuffer.writeLine(line, (OutputStream)out);
            line.clear();
            line.append(HC_RESPONSE_INSTANT);
            line.append(": ");
            line.append(HttpByteArrayCacheEntrySerializer.asStr(cacheEntry.getResponseInstant()));
            outputBuffer.writeLine(line, (OutputStream)out);
            for (String variant : cacheEntry.getVariants()) {
                line.clear();
                line.append(HC_VARIANT);
                line.append(": ");
                line.append(variant);
                outputBuffer.writeLine(line, (OutputStream)out);
            }
            line.clear();
            outputBuffer.writeLine(line, (OutputStream)out);
            line.clear();
            RequestLine requestLine = new RequestLine(cacheEntry.getRequestMethod(), cacheEntry.getRequestURI(), (ProtocolVersion)HttpVersion.HTTP_1_1);
            this.lineFormatter.formatRequestLine(line, requestLine);
            outputBuffer.writeLine(line, (OutputStream)out);
            Iterator<Header> it = cacheEntry.requestHeaderIterator();
            while (it.hasNext()) {
                line.clear();
                this.lineFormatter.formatHeader(line, it.next());
                outputBuffer.writeLine(line, (OutputStream)out);
            }
            line.clear();
            outputBuffer.writeLine(line, (OutputStream)out);
            line.clear();
            StatusLine statusLine = new StatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, cacheEntry.getStatus(), "");
            this.lineFormatter.formatStatusLine(line, statusLine);
            outputBuffer.writeLine(line, (OutputStream)out);
            Iterator<Header> it2 = cacheEntry.headerIterator();
            while (it2.hasNext()) {
                line.clear();
                this.lineFormatter.formatHeader(line, it2.next());
                outputBuffer.writeLine(line, (OutputStream)out);
            }
            line.clear();
            outputBuffer.writeLine(line, (OutputStream)out);
            outputBuffer.flush((OutputStream)out);
            if (resource != null) {
                out.write(resource.get());
            }
            out.flush();
            byte[] bytes = out.toByteArray();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialized cache entry with key {} and {} bytes", (Object)key, (Object)bytes.length);
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ResourceIOException("Exception while serializing cache entry", ex);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public HttpCacheStorageEntry deserialize(byte[] serializedObject) throws ResourceIOException {
        HttpCacheStorageEntry httpCacheStorageEntry;
        if (serializedObject == null || serializedObject.length == 0) {
            throw new ResourceIOException("Serialized object is null or empty");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(serializedObject);
        try {
            HeapResource resource;
            HashSet<String> variants;
            Instant responseDate;
            Instant requestDate;
            long length;
            String storageKey;
            CharArrayBuffer line;
            SessionInputBufferImpl inputBuffer;
            block25: {
                inputBuffer = new SessionInputBufferImpl(this.bufferSize);
                line = new CharArrayBuffer(8192);
                HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
                String versionLine = line.toString();
                if (!versionLine.equals(HC_CACHE_VERSION_LINE)) {
                    throw new ResourceIOException("Unexpected cache entry version line");
                }
                storageKey = null;
                length = -1L;
                requestDate = null;
                responseDate = null;
                variants = new HashSet<String>();
                while (true) {
                    line.clear();
                    HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
                    if (line.isEmpty()) break block25;
                    Header header = this.lineParser.parseHeader(line);
                    String name = header.getName();
                    String value = header.getValue();
                    if (name.equalsIgnoreCase(HC_CACHE_KEY)) {
                        storageKey = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase(HC_CACHE_LENGTH)) {
                        length = HttpByteArrayCacheEntrySerializer.asLong(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase(HC_REQUEST_INSTANT)) {
                        requestDate = HttpByteArrayCacheEntrySerializer.asInstant(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase(HC_RESPONSE_INSTANT)) {
                        responseDate = HttpByteArrayCacheEntrySerializer.asInstant(value);
                        continue;
                    }
                    if (!name.equalsIgnoreCase(HC_VARIANT)) break;
                    variants.add(value);
                }
                throw new ResourceIOException("Unexpected header entry");
            }
            if (storageKey == null || requestDate == null || responseDate == null) {
                throw new ResourceIOException("Invalid cache header format");
            }
            line.clear();
            HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
            RequestLine requestLine = this.lineParser.parseRequestLine(line);
            HeaderGroup requestHeaders = new HeaderGroup();
            while (true) {
                line.clear();
                HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
                if (line.isEmpty()) break;
                requestHeaders.addHeader(this.lineParser.parseHeader(line));
            }
            line.clear();
            HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
            StatusLine statusLine = this.lineParser.parseStatusLine(line);
            HeaderGroup responseHeaders = new HeaderGroup();
            while (true) {
                line.clear();
                HttpByteArrayCacheEntrySerializer.checkReadResult(inputBuffer.readLine(line, (InputStream)in));
                if (line.isEmpty()) break;
                responseHeaders.addHeader(this.lineParser.parseHeader(line));
            }
            if (length != -1L) {
                int off = 0;
                int remaining = (int)length;
                byte[] buf = new byte[remaining];
                while (remaining > 0) {
                    int i = inputBuffer.read(buf, off, remaining, (InputStream)in);
                    if (i > 0) {
                        off += i;
                        remaining -= i;
                    }
                    if (i != -1) continue;
                    throw new ResourceIOException("Unexpected end of cache content");
                }
                resource = new HeapResource(buf);
            } else {
                resource = null;
            }
            if (inputBuffer.read((InputStream)in) != -1) {
                throw new ResourceIOException("Unexpected content at the end of cache content");
            }
            HttpCacheEntry httpCacheEntry = new HttpCacheEntry(requestDate, responseDate, requestLine.getMethod(), requestLine.getUri(), requestHeaders, statusLine.getStatusCode(), responseHeaders, resource, !variants.isEmpty() ? variants : null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning deserialized cache entry with storage key '{}'", (Object)httpCacheEntry);
            }
            httpCacheStorageEntry = new HttpCacheStorageEntry(storageKey, httpCacheEntry);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ResourceIOException ex) {
                throw ex;
            }
            catch (ParseException ex) {
                throw new ResourceIOException("Invalid cache header format", ex);
            }
            catch (IOException ex) {
                throw new ResourceIOException("I/O error deserializing cache entry", ex);
            }
        }
        ((InputStream)in).close();
        return httpCacheStorageEntry;
    }

    private static String asStr(long value) {
        return Long.toString(value);
    }

    private static String asStr(Instant instant) {
        return Long.toString(instant.toEpochMilli());
    }

    private static long asLong(String value) throws ResourceIOException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new ResourceIOException("Invalid cache header format");
        }
    }

    private static Instant asInstant(String value) throws ResourceIOException {
        return Instant.ofEpochMilli(HttpByteArrayCacheEntrySerializer.asLong(value));
    }

    private static void checkReadResult(int n) throws ResourceIOException {
        if (n == -1) {
            throw new ResourceIOException("Unexpected end of stream");
        }
    }

    @Deprecated
    protected InputStream makeByteArrayInputStream(byte[] bytes) {
        return null;
    }

    @Deprecated
    protected AbstractMessageParser<ClassicHttpResponse> makeHttpResponseParser() {
        return null;
    }

    @Deprecated
    protected AbstractMessageWriter<SimpleHttpResponse> makeHttpResponseWriter(SessionOutputBuffer outputBuffer) {
        return null;
    }
}

