/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.cache.InputLimit;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.impl.cache.HeapResource;
import org.apache.hc.client5.http.impl.cache.IOUtils;
import org.apache.hc.core5.annotation.Immutable;

@Immutable
public class HeapResourceFactory
implements ResourceFactory {
    @Override
    public Resource generate(String requestId, InputStream instream, InputLimit limit) throws IOException {
        int l;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        long total = 0L;
        while ((l = instream.read(buf)) != -1) {
            outstream.write(buf, 0, l);
            if (limit == null || (total += (long)l) <= limit.getValue()) continue;
            limit.reached();
            break;
        }
        return this.createResource(outstream.toByteArray());
    }

    @Override
    public Resource copy(String requestId, Resource resource) throws IOException {
        byte[] body;
        if (resource instanceof HeapResource) {
            body = ((HeapResource)resource).getByteArray();
        } else {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            IOUtils.copyAndClose(resource.getInputStream(), outstream);
            body = outstream.toByteArray();
        }
        return this.createResource(body);
    }

    Resource createResource(byte[] buf) {
        return new HeapResource(buf);
    }
}

