/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public abstract class BufferSupplier
implements AutoCloseable {
    public static final BufferSupplier NO_CACHING = new BufferSupplier(){

        @Override
        public ByteBuffer get(int capacity) {
            return ByteBuffer.allocate(capacity);
        }

        @Override
        public void release(ByteBuffer buffer) {
        }

        @Override
        public void close() {
        }
    };

    public static BufferSupplier create() {
        return new DefaultSupplier();
    }

    public abstract ByteBuffer get(int var1);

    public abstract void release(ByteBuffer var1);

    @Override
    public abstract void close();

    public static class GrowableBufferSupplier
    extends BufferSupplier {
        private ByteBuffer cachedBuffer;

        @Override
        public ByteBuffer get(int minCapacity) {
            if (this.cachedBuffer != null && this.cachedBuffer.capacity() >= minCapacity) {
                ByteBuffer res = this.cachedBuffer;
                this.cachedBuffer = null;
                return res;
            }
            this.cachedBuffer = null;
            return ByteBuffer.allocate(minCapacity);
        }

        @Override
        public void release(ByteBuffer buffer) {
            buffer.clear();
            this.cachedBuffer = buffer;
        }

        @Override
        public void close() {
            this.cachedBuffer = null;
        }
    }

    private static class DefaultSupplier
    extends BufferSupplier {
        private final Map<Integer, Deque<ByteBuffer>> bufferMap = new HashMap<Integer, Deque<ByteBuffer>>(1);

        private DefaultSupplier() {
        }

        @Override
        public ByteBuffer get(int size) {
            Deque<ByteBuffer> bufferQueue = this.bufferMap.get(size);
            if (bufferQueue == null || bufferQueue.isEmpty()) {
                return ByteBuffer.allocate(size);
            }
            return bufferQueue.pollFirst();
        }

        @Override
        public void release(ByteBuffer buffer) {
            buffer.clear();
            Deque<ByteBuffer> bufferQueue = this.bufferMap.get(buffer.capacity());
            if (bufferQueue == null) {
                bufferQueue = new ArrayDeque<ByteBuffer>(1);
                this.bufferMap.put(buffer.capacity(), bufferQueue);
            }
            bufferQueue.addLast(buffer);
        }

        @Override
        public void close() {
            this.bufferMap.clear();
        }
    }
}

