/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafkaesqueesque.common.KafkaFuture;
import org.apache.kafkaesqueesque.common.TopicPartitionReplica;
import org.apache.kafkaesqueesque.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeReplicaLogDirsResult {
    private final Map<TopicPartitionReplica, KafkaFuture<ReplicaLogDirInfo>> futures;

    DescribeReplicaLogDirsResult(Map<TopicPartitionReplica, KafkaFuture<ReplicaLogDirInfo>> futures) {
        this.futures = futures;
    }

    public Map<TopicPartitionReplica, KafkaFuture<ReplicaLogDirInfo>> values() {
        return this.futures;
    }

    public KafkaFuture<Map<TopicPartitionReplica, ReplicaLogDirInfo>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(new KafkaFuture.BaseFunction<Void, Map<TopicPartitionReplica, ReplicaLogDirInfo>>(){

            @Override
            public Map<TopicPartitionReplica, ReplicaLogDirInfo> apply(Void v) {
                HashMap<TopicPartitionReplica, ReplicaLogDirInfo> replicaLogDirInfos = new HashMap<TopicPartitionReplica, ReplicaLogDirInfo>();
                for (Map.Entry entry : DescribeReplicaLogDirsResult.this.futures.entrySet()) {
                    try {
                        replicaLogDirInfos.put((TopicPartitionReplica)entry.getKey(), (ReplicaLogDirInfo)((KafkaFuture)entry.getValue()).get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                return replicaLogDirInfos;
            }
        });
    }

    public static class ReplicaLogDirInfo {
        private final String currentReplicaLogDir;
        private final long currentReplicaOffsetLag;
        private final String futureReplicaLogDir;
        private final long futureReplicaOffsetLag;

        ReplicaLogDirInfo() {
            this(null, -1L, null, -1L);
        }

        ReplicaLogDirInfo(String currentReplicaLogDir, long currentReplicaOffsetLag, String futureReplicaLogDir, long futureReplicaOffsetLag) {
            this.currentReplicaLogDir = currentReplicaLogDir;
            this.currentReplicaOffsetLag = currentReplicaOffsetLag;
            this.futureReplicaLogDir = futureReplicaLogDir;
            this.futureReplicaOffsetLag = futureReplicaOffsetLag;
        }

        public String getCurrentReplicaLogDir() {
            return this.currentReplicaLogDir;
        }

        public long getCurrentReplicaOffsetLag() {
            return this.currentReplicaOffsetLag;
        }

        public String getFutureReplicaLogDir() {
            return this.futureReplicaLogDir;
        }

        public long getFutureReplicaOffsetLag() {
            return this.futureReplicaOffsetLag;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.futureReplicaLogDir != null) {
                builder.append("(currentReplicaLogDir=").append(this.currentReplicaLogDir).append(", futureReplicaLogDir=").append(this.futureReplicaLogDir).append(", futureReplicaOffsetLag=").append(this.futureReplicaOffsetLag).append(")");
            } else {
                builder.append("ReplicaLogDirInfo(currentReplicaLogDir=").append(this.currentReplicaLogDir).append(")");
            }
            return builder.toString();
        }
    }
}

