/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common;

import java.util.HashMap;

public enum ConsumerGroupState {
    UNKNOWN("Unknown"),
    PREPARING_REBALANCE("PreparingRebalance"),
    COMPLETING_REBALANCE("CompletingRebalance"),
    STABLE("Stable"),
    DEAD("Dead"),
    EMPTY("Empty");

    private static final HashMap<String, ConsumerGroupState> NAME_TO_ENUM;
    private final String name;

    private ConsumerGroupState(String name) {
        this.name = name;
    }

    public static ConsumerGroupState parse(String name) {
        ConsumerGroupState state = NAME_TO_ENUM.get(name);
        return state == null ? UNKNOWN : state;
    }

    public String toString() {
        return this.name;
    }

    static {
        NAME_TO_ENUM = new HashMap();
        for (ConsumerGroupState state : ConsumerGroupState.values()) {
            NAME_TO_ENUM.put(state.name, state);
        }
    }
}

