/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hive.streaming.AbstractStreamingTransaction;
import org.apache.hive.streaming.HiveStreamingConnection;
import org.apache.hive.streaming.StreamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnManagedSingleTransaction
extends AbstractStreamingTransaction {
    private static final Logger LOG = LoggerFactory.getLogger((String)UnManagedSingleTransaction.class.getName());
    private final String username;
    private final HiveStreamingConnection conn;
    private final Set<String> partitions = Sets.newHashSet();

    public UnManagedSingleTransaction(HiveStreamingConnection conn) throws StreamingException {
        assert (conn.getWriteId() != null);
        this.conn = conn;
        this.username = conn.getUsername();
        this.recordWriter = conn.getRecordWriter();
        this.state = HiveStreamingConnection.TxnState.INACTIVE;
        this.txnToWriteIds = Lists.newArrayList((Object[])new TxnToWriteId[]{new TxnToWriteId(-1L, conn.getWriteId().longValue())});
        boolean success = false;
        try {
            this.recordWriter.init(conn, ((TxnToWriteId)this.txnToWriteIds.get(0)).getWriteId(), ((TxnToWriteId)this.txnToWriteIds.get(0)).getWriteId(), conn.getStatementId());
            success = true;
        }
        finally {
            this.markDead(success);
        }
    }

    @Override
    public void beginNextTransaction() throws StreamingException {
        this.beginNextTransactionImpl("No more transactions available in next batch for connection: " + String.valueOf(this.conn) + " user: " + this.username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Set<String> partitions, String key, String value) throws StreamingException {
        this.checkIsClosed();
        boolean success = false;
        try {
            this.commitImpl();
            success = true;
        }
        finally {
            this.markDead(success);
        }
    }

    private void commitImpl() throws StreamingException {
        this.recordWriter.flush();
        ArrayList<String> partNames = new ArrayList<String>(this.recordWriter.getPartitions());
        this.partitions.addAll(partNames);
        this.state = HiveStreamingConnection.TxnState.PREPARED_FOR_COMMIT;
    }

    @Override
    public void abort() {
        if (this.isTxnClosed.get()) {
            return;
        }
        this.state = HiveStreamingConnection.TxnState.ABORTED;
    }

    @Override
    public void close() throws StreamingException {
        if (this.isClosed()) {
            return;
        }
        this.isTxnClosed.set(true);
        this.abort();
        try {
            this.closeImpl();
        }
        catch (Exception ex) {
            LOG.error("Fatal error on " + this.toString() + "; cause " + ex.getMessage(), (Throwable)ex);
            throw new StreamingException("Unable to close", ex);
        }
    }

    private void closeImpl() throws StreamingException {
        this.state = HiveStreamingConnection.TxnState.INACTIVE;
        this.recordWriter.close();
    }

    public String toString() {
        if (this.txnToWriteIds == null || this.txnToWriteIds.isEmpty()) {
            return "{}";
        }
        return "TxnId/WriteIds=[" + ((TxnToWriteId)this.txnToWriteIds.get(0)).getWriteId() + "] on connection = " + String.valueOf(this.conn) + "; status=" + String.valueOf((Object)this.state);
    }

    @Override
    public Set<String> getPartitions() {
        return this.partitions;
    }
}

